% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/station_coverage.R
\name{station_coverage}
\alias{station_coverage}
\title{Find out which additional data fields a station has recorded}
\usage{
station_coverage(station_id, years = NULL, wide_tbl = FALSE,
  grouping = NULL, local_file_dir = NULL)
}
\arguments{
\item{station_id}{A station identifier composed of the station's USAF and
WBAN numbers, separated by a hyphen.}

\item{years}{The years for which station met data will be collected. If not
specified then all records for all available years will be obtained for the
station.}

\item{wide_tbl}{A wide table of a single row for the station can be generated
by setting this to \code{TRUE}. In this arrangement, additional data field
categories will appear as columns (having counts of observations as values
for the period of \code{years}). This is useful when collecting station coverage
tables for multiple stations, since the rows can be safely bound together.
By default, this is set to \code{FALSE}.}

\item{grouping}{An option to group and summarize counts of observations by
\code{"year"} or by \code{"month"}. If these keywords aren't provided then
summarization will occur over the entire period specified by \code{years}.}

\item{local_file_dir}{Path to local meteorological data files. If specified,
then data files will be downloaded to and retrieved from this location and
not from the remote data store.}
}
\value{
A tibble.
}
\description{
Get a tibble of information on which additional data fields a particular
station has during a specified year range.
}
\examples{
\dontrun{
# Obtain a coverage report of the
# additional data that the met
# station with the ID value of
# "999999-63897" has over a two-
# year period
met_data <- 
  station_coverage(
    station_id = "999999-63897",
    years = 2013:2014
  )
}

}
