% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeAmmi.R
\name{gxeAmmi}
\alias{gxeAmmi}
\title{AMMI analysis}
\usage{
gxeAmmi(
  TD,
  trials = names(TD),
  trait,
  nPC = 2,
  byYear = FALSE,
  center = TRUE,
  excludeGeno = NULL,
  useWt = FALSE
)
}
\arguments{
\item{TD}{An object of class \code{\link{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{nPC}{An integer specifying the number of principal components used
as multiplicative term of genotype-by-trial interaction. If \code{NULL}, the
number of principal components is determined by the algorithm using
forward selection. See details.}

\item{byYear}{Should the analysis be done by year? If \code{TRUE} the data
is split by the variable year, analysis is performed and the results are
merged together and returned.}

\item{center}{Should the variables be shifted to be zero centered?}

\item{excludeGeno}{An optional character vector with names of genotypes to
be excluded from the analysis. If \code{NULL}, all genotypes are used.}

\item{useWt}{Should weighting be used when modeling? Requires a column
\code{wt} in \code{TD}.}
}
\value{
An object of class \code{\link{AMMI}}, a list containing:
\item{envScores}{A matrix with environmental scores.}
\item{genoScores}{A matrix with genotypic scores.}
\item{importance}{A data.frame containing the importance of the principal
components.}
\item{anova}{A data.frame containing anova scores of the AMMI analysis.}
\item{fitted}{A data.frame containing fitted values from the AMMI model.}
\item{trait}{A character string containing the analyzed trait.}
\item{envMean}{A numerical vector containing the environmental means.}
\item{genoMean}{A numerical vector containing the genotypic means.}
\item{overallMean}{A numerical value containing the overall mean.}
If \code{byYear} = \code{TRUE}, all returned items in the AMMI object except
\code{fitted} will consist of a list of results by year.
}
\description{
The Additive Main Effects and Multiplicative Interaction (AMMI) model fits
a model which involves the Additive Main effects (i.e. genotype and trial)
along with Multiplicative Interaction effects. The additive effects are the
classical ANOVA main effects for genotype and environment, the
multiplicative effects follow from a principal component analysis on the
interaction residuals (= genotype by environment means after adjustment for
additive genotype and environment effects). This results in an interaction
characterized by Interaction Principal Components (IPCA) enabling
simultaneous plotting of genotypes and trials.\cr\cr
The parameter \code{nPC} is used to indicate the number of principal
components that is used in the principal component analysis (PCA). By setting
this parameter to \code{NULL} the algorithm determines the best number of
principal components (see Details).\cr\cr
By specifying the parameter \code{byYear = TRUE}, a separate analysis will be
done for every year in the data. Combining the option with \code{nPC = NULL}
may result in different numbers of principal components per year. The AMMI
estimates will still be returned as a single data.frame, but the other
results will be either lists or arrays.
}
\details{
First a linear model \eqn{trait = genotype + trial + \epsilon} is fitted with
both genotype and trial fixed components in the model.\cr
The residuals from the fitted model are then used in a PCA. If \code{nPC} is
not \code{NULL} a single PCA is done using \code{\link[stats]{prcomp}} with
maximum rank \code{nPC}.\cr
In case \code{nPC = NULL}, the PCA is first done with one PC. Then using
forward selection one by one the number of PCs is increased as long as the
added component is significant in the analysis.\cr
AMMI estimates are then computed using the results of the PCA.\cr
}
\examples{
## Run AMMI analysis on TDMaize.
geAmmi <- gxeAmmi(TD = TDMaize, trait = "yld")

## Summarize results.
summary(geAmmi)

## Create a biplot of genotypes and environment interaction with PC1 and PC2.
plot(geAmmi, plotType = "AMMI2")

## Create a pdf report summarizing the results.
\donttest{
report(geAmmi, outfile = tempfile(fileext = ".pdf"))
}

}
\references{
Gauch H.G. (1992) Statistical Analysis of Regional Yield Trials:
AMMI Analysis of Factorial Designs. Elsevier, Amsterdam.

Yan, W., Kang, M. (2002). GGE Biplot Analysis. Boca Raton: CRC
Press.
}
\seealso{
Other AMMI: 
\code{\link{fitted.AMMI}()},
\code{\link{plot.AMMI}()},
\code{\link{report.AMMI}()},
\code{\link{residuals.AMMI}()}
}
\concept{AMMI}
