# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Extract Component of Random Samples
#'
#' @param a Array containing the state vectors for each time point
#'   and random sample.
#' @param Z Z system matrix of the State Space model component.
#'
#' @noRd
ExtractComponentC <- function(a, Z) {
    .Call(`_statespacer_ExtractComponentC`, a, Z)
}

#' Employ the Fast Kalman Smoother on multiple samples
#'
#' @param y Array of samples.
#' @param a Initial values of the state vector.
#' @param P_inf Diffuse part of the variance - covariance matrix of the
#'   state vector.
#' @param P_star Stationary part of the variance - covariance matrix of the
#'   state vector.
#' @param Z Z system matrix of the State Space model.
#' @param T T system matrix of the State Space model.
#' @param R R system matrix of the State Space model.
#' @param Q Q system matrix of the State Space model.
#' @param initialisation_steps Number of steps that were
#'   needed during initialisation.
#' @param transposed_state Boolean indicating whether a
#'   transposed variant of the state should be returned.
#'
#' @noRd
FastSmootherC <- function(y, a, P_inf, P_star, Z, T, R, Q, initialisation_steps, transposed_state) {
    .Call(`_statespacer_FastSmootherC`, y, a, P_inf, P_star, Z, T, R, Q, initialisation_steps, transposed_state)
}

#' Employ the Kalman Filter and Smoother
#'
#' @param y Matrix of observations.
#' @param y_isna Matrix indicating which observations are missing.
#' @param a Initial values of the state vector.
#' @param P_inf Diffuse part of the variance - covariance matrix of the
#'   state vector.
#' @param P_star Stationary part of the variance - covariance matrix of the
#'   state vector.
#' @param Z Z system matrix of the State Space model.
#' @param T T system matrix of the State Space model.
#' @param R R system matrix of the State Space model.
#' @param Q Q system matrix of the State Space model.
#' @param diagnostics Boolean indicating whether diagnostics should be computed.
#'
#' @noRd
KalmanC <- function(y, y_isna, a, P_inf, P_star, Z, T, R, Q, diagnostics) {
    .Call(`_statespacer_KalmanC`, y, y_isna, a, P_inf, P_star, Z, T, R, Q, diagnostics)
}

#' Employ the Kalman Filter to calculate the loglikelihood
#'
#' @param y Matrix of observations.
#' @param y_isna Matrix indicating which observations are missing.
#' @param a Initial values of the state vector.
#' @param P_inf Diffuse part of the variance - covariance matrix of the
#'   state vector.
#' @param P_star Stationary part of the variance - covariance matrix of the
#'   state vector.
#' @param Z Z system matrix of the State Space model.
#' @param T T system matrix of the State Space model.
#' @param R R system matrix of the State Space model.
#' @param Q Q system matrix of the State Space model.
#'
#' @noRd
LogLikC <- function(y, y_isna, a, P_inf, P_star, Z, T, R, Q) {
    .Call(`_statespacer_LogLikC`, y, y_isna, a, P_inf, P_star, Z, T, R, Q)
}

#' Draw Random Samples of a State Space Component
#'
#' @param nsim Number of random samples to draw.
#' @param repeat_Q Number of times the drawing of random samples
#'   using Q should be repeated.
#' @param N Number of time points.
#' @param a Initial values of the state vector of the component.
#' @param Z Z system matrix of the State Space model component.
#' @param T T system matrix of the State Space model component.
#' @param R R system matrix of the State Space model component.
#' @param Q Q system matrix of the State Space model component.
#' @param P_star P_star system matrix of the State Space model component.
#'   Only used when draw_initial = true.
#' @param draw_initial Boolean indicating whether the initial state
#'   should be simulated.
#' @param eta_only Boolean indicating whether only the
#'   disturbances should be simulated.
#' @param transposed_state Boolean indicating whether a
#'   transposed variant of the state should be returned.
#'
#' @noRd
SimulateC <- function(nsim, repeat_Q, N, a, Z, T, R, Q, P_star, draw_initial, eta_only, transposed_state) {
    .Call(`_statespacer_SimulateC`, nsim, repeat_Q, N, a, Z, T, R, Q, P_star, draw_initial, eta_only, transposed_state)
}

