% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/transformPermCoding.R
\name{transformPermCoding}
\alias{transformPermCoding}
\title{A function to generate a vector from an index-transformation vector from a permutation coding scheme}
\usage{
transformPermCoding(target_pattern, ndemb)
}
\arguments{
\item{target_pattern}{A numeric matrix that specifies the pattern to be transformed into the position vector.}

\item{ndemb}{Embedding dimension of the ordinal patterns (i.e. sliding window size). Should be chosen such as length(x) >> ndemb}
}
\value{
A numeric vector of length factorial(ndemb), which contains the positions of the corresponding patterns in the Keller Coding scheme.
}
\description{
Generates a position vector to change the ordinal pattern distribution in the default permutation coding scheme (i.e. generated by ordinal_pattern_distribution(x, ndemb)) into a user-specified coding scheme. This is a required input for the function changePermCodingOPD.
}
\details{
This function returns a character vector to transform the output of ordinal_pattern_distribution (permutation coding as of Keller and Sinn, 2005) into a user-specified permutation coding scheme.
For example, pattern #5 in "lehmerperm" (ndemb = 5) is given by the ranks c(0, 1, 4, 2, 3). This corresponds to pattern #41 in the (original) Keller coding scheme, as given by transformPermCoding(target_pattern = "lehmerperm", ndemb = 5)[5].
}
\examples{
transformPermCoding(target_pattern = "lehmerperm", ndemb = 4)
}
\author{
Sebastian Sippel
}
\references{
Olivares, F., Plastino, A. and Rosso, O.A., 2012. Ambiguities in Bandt-Pompe's methodology for local entropic quantifiers. Physica A: Statistical Mechanics and its Applications, 391(8), pp.2518-2526.
}

