% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{MPR_complexity}
\alias{MPR_complexity}
\title{A function to compute the MPR-complexity}
\usage{
MPR_complexity(opd)
}
\arguments{
\item{opd}{A numeric vector that details an ordinal pattern distribution.}
}
\value{
The normalized MPR complexity measure in the range [0, 1].
}
\description{
The function computes the MPR complexity, i.e. a generalized (global) complexity measure based on the Jenson-Shannon divergence.
}
\details{
Generalized complexity measures combine an information measure (i.e. entropy) with the distance of the distribution from the uniform distribution ("disequilibrium").
As a global measure, MPR-complexity is insensitive to the permutation coding scheme.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
opd = ordinal_pattern_distribution(x = x, ndemb = 6)
MPR_complexity(opd)
}
\author{
Sebastian Sippel
}
\references{
Martin, M.T., Plastino, A. and Rosso, O.A., 2006. Generalized statistical complexity measures: Geometrical and analytical properties. Physica A: Statistical Mechanics and its Applications, 369(2), pp.439-462.
}

