% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.acf}
\alias{graph.acf}
\title{Auto Correlation Function Estimation for Graphs}
\usage{
graph.acf(x, plot = TRUE)
}
\arguments{
\item{x}{a list of adjacency (symmetric) matrices of undirected graphs. For
unweighted graphs, each matrix contains only 0s and 1s. For weighted graphs,
each matrix may contains real values that correspond to the weights of the
edges.}

\item{plot}{logical. If TRUE (default) the graph.acf is plotted.}
}
\value{
An object of class acf.
}
\description{
The function \code{graph.acf} computes estimates of the autocorrelation
function for graphs.
}
\examples{
require(igraph)
x <- list()
p <- array(0, 100)
p[1:3] <- rnorm(3)
for (t in 4:100) {
    p[t] <- 0.5*p[t-3] + rnorm(1)
}
ma <- max(p)
mi <- min(p)
p <- (p - mi)/(ma-mi)
for (t in 1:100) {
    x[[t]] <- get.adjacency(erdos.renyi.game(100, p[t]))
}
graph.acf(x, plot=TRUE)

}
\references{
Fujita, A., Takahashi, D. Y., Balardin, J. B., Vidal, M. C. and Sato, J. R.
(2017) Correlation between graphs with an application to brain network
analysis. \emph{Computational Statistics & Data Analysis} \emph{109}, 76-92.
}
\keyword{autocorrelation}
