% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_character_dimensions.R
\name{character_dimensions}
\alias{character_dimensions}
\alias{character_dimensions.star_schema}
\title{Transform dimension numeric attributes to character}
\usage{
character_dimensions(st, length_integers = list(), NA_replacement_value = NULL)

\method{character_dimensions}{star_schema}(st, length_integers = list(), NA_replacement_value = NULL)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{length_integers}{A \code{list} of pairs name = length, for each attribute name its length.}

\item{NA_replacement_value}{A string, value to replace NA values.}
}
\value{
A \code{star_schema} object.
}
\description{
Transforms numeric type attributes of dimensions into character type. In a
\code{star_schema} numerical data are measurements that are situated in the facts.
Numerical data in dimensions are usually codes, day, week, month or year
numbers. There are tools that consider any numerical data to be a
measurement, for this reason it is appropriate to transform the numerical
data of dimensions into character data.
}
\details{
It allows indicating the amplitude for some fields, filling with zeros on the
left. This is useful to make the alphabetical order of the result correspond
to the numerical order.

It also allows indicating the literal to be used in case the numerical value
is not defined.

If a role playing dimension has been defined, the transformation is performed
on it.
}
\examples{

st <- star_schema(mrs_age_test, dm_mrs_age) |>
  role_playing_dimension(
    dim_names = c("when", "when_available"),
    name = "When Common",
    attributes = c("date", "week", "year")
  ) |>
  character_dimensions(length_integers = list(week = 2),
                       NA_replacement_value = "Unknown")

}
\seealso{
Other star schema and constellation definition functions: 
\code{\link{constellation}()},
\code{\link{role_playing_dimension}()},
\code{\link{snake_case}()},
\code{\link{star_schema}()}
}
\concept{star schema and constellation definition functions}
