% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv.starnet}
\alias{cv.starnet}
\title{Model comparison}
\usage{
cv.starnet(
  y,
  X,
  family = "gaussian",
  nalpha = 21,
  alpha = NULL,
  nfolds.ext = 10,
  nfolds.int = 10,
  foldid.ext = NULL,
  foldid.int = NULL,
  type.measure = "deviance",
  alpha.meta = 1,
  nzero = NULL,
  intercept = NULL,
  upper.limit = NULL,
  unit.sum = NULL,
  ...
)
}
\arguments{
\item{y}{response\strong{:}
numeric vector of length \eqn{n}}

\item{X}{covariates\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{family}{character "gaussian", "binomial" or "poisson"}

\item{nalpha}{number of \code{alpha} values}

\item{alpha}{elastic net mixing parameters\strong{:}
vector of length \code{nalpha} with entries
between \eqn{0} (ridge) and \eqn{1} (lasso);
or \code{NULL} (equidistance)}

\item{nfolds.ext, nfolds.int, foldid.ext, foldid.int}{number of folds (\code{nfolds})\strong{:}
positive integer;
fold identifiers (\code{foldid})\strong{:} 
vector of length \eqn{n} with entries between \eqn{1} and \code{nfolds},
or \code{NULL},
for hold-out (single split) instead of cross-validation (multiple splits)\strong{:}
set \code{foldid.ext} to \eqn{0} for training and to \eqn{1} for testing samples}

\item{type.measure}{loss function\strong{:}
character "deviance", "class", "mse" or "mae"
(see \code{\link[glmnet]{cv.glmnet}})}

\item{alpha.meta}{meta-learner\strong{:}
value between \eqn{0} (ridge) and \eqn{1} (lasso)
for elastic net regularisation; 
\code{NA} for convex combination}

\item{nzero}{number of non-zero coefficients\strong{:}
scalar/vector including positive integer(s) or \code{NA};
or \code{NULL} (no post hoc feature selection)}

\item{intercept, upper.limit, unit.sum}{settings for meta-learner\strong{:} logical,
or \code{NULL}
(\code{intercept=!is.na(alpha.meta)},
\code{upper.limit=TRUE},
\code{unit.sum=is.na(alpha.meta)})}

\item{...}{further arguments (not applicable)}
}
\value{
List containing the cross-validated loss
(or out-of sample loss if \code{nfolds.ext} equals two,
and \code{foldid.ext} contains zeros and ones).
The slot \code{meta} contains the loss from the stacked elastic net
(\code{stack}), the tuned elastic net (\code{tune}), ridge, lasso,
and the intercept-only model (\code{none}).
The slot \code{base} contains the loss from the base learners.
And the slot \code{extra} contains the loss from the restricted
stacked elastic net (\code{stack}), lasso, and lasso-like elastic net
(\code{enet}),
with the maximum number of non-zero coefficients shown in the column name.
}
\description{
Compares stacked elastic net, tuned elastic net, ridge and lasso.
}
\examples{
\dontshow{
if(!grepl('SunOS',Sys.info()['sysname'])){
set.seed(1)
n <- 50; p <- 20
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
y <- rnorm(n=n,mean=rowSums(X[,1:20]))
loss <- cv.starnet(y=y,X=X,nfolds.ext=2,nfolds.int=3)}}
\donttest{
loss <- cv.starnet(y=y,X=X)}

}
