% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_pdf.R
\name{rotate_pdf}
\alias{rotate_pdf}
\title{Rotate entire pdf document}
\usage{
rotate_pdf(page_rotation = c(0, 90, 180, 270), input_filepath = NULL,
  output_filepath = NULL)
}
\arguments{
\item{page_rotation}{An integer value from the vector c(0, 90, 180, 270).
Each option sets the page rotation as follows (in degrees):
north: 0, east: 90, south: 180, west: 270}

\item{input_filepath}{the path of the input PDF file.
The default is set to NULL. IF NULL, it  prompt the user to
select the folder interactively.}

\item{output_filepath}{the path of the output output PDF file.
The default is set to NULL. IF NULL, it  prompt the user to
select the folder interactivelye.}
}
\value{
this function returns a PDF document with the rotated pages
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to rotate the entire PDF document

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
# This command promts the user to select the file interactively.
# Rotate the entire PDF document to 90 degrees clockwise
rotate_pdf(page_rotation = 90)
}

\dontrun{
dir <- tempdir()
require(lattice)
for(i in 1:3) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}
output_file <- file.path(dir, paste('Full_pdf.pdf',  sep = ""))
staple_pdf(input_directory = dir, output_file)
input_path <- file.path(dir, paste("Full_pdf.pdf",  sep = ""))
output_path <-  file.path(dir, paste("rotated_pdf.pdf",  sep = ""))
rotate_pdf( page_rotation = 90,  input_path, output_path)
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Priyanga Dilini Talagala
}
