% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputData.R
\name{prepareInputData}
\alias{prepareInputData}
\title{Transformation of a NONMEM-readable dataset to a Stan-readable list}
\usage{
prepareInputData(data.type = "population", data.source = NULL,
  data.file = NULL, model = NULL, inits = NULL, covar = NULL)
}
\arguments{
\item{data.type}{a string to specify the type of the data ("population" or "individual").}

\item{data.source}{the name of an R data frame that serves as the source data. If not provided, the next argument
\code{data.file} will be checked to locate the data in the system.}

\item{data.file}{a string to specify the path of the data file. It will be ignored if the previous argument 
\code{data.source} is already provided; but it will be required if \code{data.source} is not provided.}

\item{model}{a \code{PMXStanModel} object that will be fitted to the current dataset.}

\item{inits}{a string providing the colume name of initial values of the observed state variable for each individual 
in the current dataset, or a numerical vector of initial values for each individual.}

\item{covar}{a string or a vector of strings providing colume name(s) of covariate(s) in the current dataset, 
which needs to be used either in model building or post-processing (e.g. goodness-of-fit plotting
\code{\link{obs.vs.pred}} and \code{\link{rsd.vs.pred}} for a \code{\link{PMXStanFit}} object), or both.}
}
\value{
The returned list contains four elements:
\item{data.type}{a string indicating the data type for future reference; the same as the argument \code{data.type}.}
\item{standata}{a list by itself to be fed into the model-specific Stan code.}
\item{ID}{a vector of IDs whose observations have been included in \code{standata} above. Note that a proof checking
    step has been performed to make sure that every subject included in Stan input data has both valid dosing and
    observation records; therefore, this set of \code{ID}'s might be the same as those in the original data table,
    but it might also be a subset only. The purpose of this step is to avoid errors at the future sampling step due
    to lack of dosing records or observations.
}
\item{d.cov}{a data frame with columns of subject IDs and values for each selected covariates defined by the \code{covar} 
}

A special consideration should be noted when handling data from a single subject, i.e. when \code{data.type} is set to 
"individual". Due to the strict requirement with data type specification in Stan grammar and the underlying mechanisms 
how C++ handles different data types, to avoid the comlexity caused by data from a single subject, a "dummy" subject
has been attached in these cases, with a single dose of 0 and the initial observation set the same as the real subject.
}
\description{
Prepares input data (a list) for the model-specific Stan code from a conventional PK/PD dataset for NONMEM 
(usually a table in .txt or .csv format).
}
\details{
\code{prepareInputData} rewrites a table consisting of relevant columns according to NONMEM conventions to a \code{list} 
consisting of named vectors compatible to the auto-generated model-specific Stan code. It also allows users to specify 
column names for initial values of the observed state variable for an ODE system, and column names for relevant 
covariates that will be explored more through modeling or post-processing.

Currently, \code{prepareInputData} takes two different formats (.txt or .csv) of a NONMEM data file. The minimally 
required columns in this data file are: \code{TIME}, \code{DV}, \code{AMT},and \code{EVID}. If \code{data.type} is set 
to "population", a column \code{ID} is also required. If the route of drug administration is set to "IV_infusion" 
(through argument \code{route} for \code{PMXStanModel}), a column \code{RATE} is also required.

For more details on the data structure of the returned list, please see \emph{Value} section.
}
\examples{
m <- PMXStanModel(path = tempfile("pk_m1"))
data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m)
str(dat)
}
\author{
Yuan Xiong and Wenping Wang
}
\seealso{
\code{\link[base]{list}} for general information on \code{R} lists; 
\code{\link{PMXStanModel}} for the initialization of a \code{PMXStanModel} object;
\code{\link{PMXStanFit}} for the generation of a \code{PMXStanFit} object, running a model-specific Stan executable 
and linking to an input data list to generate posterior samples of parameters.
}

