% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alertify-dependencies.R, R/alertify-handler.R
\name{useAlertify}
\alias{useAlertify}
\alias{alertify}
\alias{alertify_alert}
\alias{alertify_notify}
\title{Alertify}
\usage{
useAlertify()

alertify_alert(
  title = "Alert Title",
  message = "Alert Message",
  type = "success",
  btn_label = "OK",
  transition = "pulse",
  transition_off = FALSE,
  closable = TRUE,
  auto_reset = FALSE,
  frameless = FALSE,
  maximizable = FALSE,
  modal = FALSE,
  movable = FALSE,
  move_bounded = TRUE,
  overflow = FALSE,
  padding = TRUE,
  pinnable = FALSE,
  resizeable = FALSE,
  start_maximized = FALSE,
  session = getDefaultReactiveDomain()
)

alertify_notify(
  message = "Alert Message",
  type = "success",
  delay = 5,
  position = "bottom-right",
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{title}{Dialog title.}

\item{message}{Dialog contents.}

\item{type}{Dialog type. Defaults to \code{"success"}. Valid values are:
\itemize{
\item \code{"success"}
\item \code{"error"}
\item \code{"warning"}
\item \code{"message"}
}}

\item{btn_label}{The \code{OK} button label.}

\item{transition}{Transition effect to be used when showing/hiding the dialog. Defaults to \code{"pulse"}. Valid values are:
\itemize{
\item \code{"pulse"}
\item \code{"slide"}
\item \code{"zoom"}
\item \code{"fade"}
\item \code{"flipx"}
\item \code{"flipy"}
}}

\item{transition_off}{Logical; if \code{TRUE}, transition effect is disabled. Defaults to \code{FALSE}.}

\item{closable}{Logical; if \code{TRUE} (the default), a |code{Close} button is displayed in the header of the dialog.}

\item{auto_reset}{Logical; if \code{TRUE} (the default), the dialog will reset size/position on window resize.}

\item{frameless}{Logical; if \code{TRUE}, hides both header and footer of the dialog. Defaults to \code{FALSE}.}

\item{maximizable}{Logical; if \code{TRUE} (the default), the \code{Maximize} button is displayed in the header of the dialog.}

\item{modal}{Logical; if \code{TRUE} (the default), a screen dimmer will be used and access to the page contents will be prevented.}

\item{movable}{Logical; if \code{TRUE} (the default), the dialog is movable.}

\item{move_bounded}{Logical; if \code{TRUE}, the dialog is not allowed to go off-screen. Defaults to \code{FALSE}.}

\item{overflow}{Logical; if \code{TRUE} (the default), the content overflow is managed by the dialog}

\item{padding}{Logical; if \code{TRUE} (the default), the content padding is managed by the dialog.}

\item{pinnable}{Logical; if \code{TRUE} (the default), the \code{Pin} button is displayed in the header of the dialog.}

\item{resizeable}{Logical; if \code{TRUE}, the dialog is resizable. Defaults to \code{FALSE}.}

\item{start_maximized}{Logical; if \code{TRUE}, the dialog will start in a maximized state. Defaults to \code{FALSE}.}

\item{session}{Shiny session object.}

\item{delay}{The time (in seconds) to wait before the notification is auto-dismissed. \code{0} will keep notification open till clicked.}

\item{position}{Position of the notification. Defaults to \code{"bottom-right"}. Valid values are:
\itemize{
\item \code{"bottom-right"}
\item \code{"bottom-left"}
\item \code{"bottom-center"}
\item \code{"top-right"}
\item \code{"top-left"}
\item \code{"top-center"}
}}
}
\value{
None
}
\description{
Pretty browser alerts and notifications.
}
\section{Functions}{

\itemize{
\item \code{useAlertify}: Dependencies to include in your UI.
\item \code{alertify_alert}: Display alerts.
\item \code{alertify_notify}: Display notifications.
}
}

\examples{

# Example 1: Alert
if (interactive()) {
library(shiny)
library(standby)

ui <- fluidPage(

  useAlertify(), # include dependencies
  actionButton(inputId = "btn",
               label   = "Alert Demo")

)

server <- function(input, output, session) {

  observeEvent(input$btn, {
    # display alert
    alertify_alert("Hey there!", "Thank you for exploring standby!")
  })
}

shinyApp(ui, server)
}

# Example 2: Notification
if (interactive()) {
library(shiny)
library(standby)

ui <- fluidPage(

  useAlertify(), # include dependencies
  actionButton(inputId = "btn",
               label   = "Notification Demo")

)

server <- function(input, output, session) {

  observeEvent(input$btn, {
    # display notification
    alertify_notify("Hey there! Thank you for exploring standby!")
  })
}

shinyApp(ui, server)
}

}
