% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fungraph_glasseel.R
\name{fungraph_glasseel}
\alias{fungraph_glasseel}
\title{Graph function for glass eel migration. Differs from fungraph as it does not
draw the ggplot graph for month}
\usage{
fungraph_glasseel(report_mig, table, time.sequence, taxa, stage, dc = null,
  silent, color = NULL, color_ope = NULL, ...)
}
\arguments{
\item{report_mig}{an object of class \link{report_mig-class} or an
object of class \link{report_mig_mult-class}}

\item{table}{a data frame with the results}

\item{time.sequence}{a vector POSIXt}

\item{taxa}{the species}

\item{stage}{the stage}

\item{dc}{the counting device, default to null, only necessary for \link{report_mig_mult-class}}

\item{silent}{Message displayed or not}

\item{color}{Default NULL, a vector of length 11 of color in the following order, numbers, weight, working, stopped, 1...5 types of operation,
the 2 latest colors are not used but kept for consistency with fungraph
for the fishway, if null will be set to brewer.pal(12,"Paired")[c(4,6,1,2,3,5,7,8,10,11,12)]}

\item{color_ope}{Default NULL, a vector of color for the operations. Default to brewer.pal(4,"Paired")}

\item{...}{additional parameters passed to plot, main, ylab, cex.main, font.main, type, xlim, ylim, lty, bty, pch
it is not possible to change xlim}
}
\description{
This graph will also plot numbers and bars according to whether the glass
eel have been counted through weight or numbers
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

