% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_text.R
\name{contrast_text}
\alias{contrast_text}
\title{Contrast Text Color}
\usage{
contrast_text(
  background,
  light_text = "white",
  dark_text = "black",
  threshold = 0.5,
  method = "perceived_2"
)
}
\arguments{
\item{background}{A hex/named color value that represents the background.}

\item{light_text}{A hex/named color value that represents the light text
color.}

\item{dark_text}{A hex/named color value that represents the dark text color.}

\item{threshold}{A numeric value between 0 and 1 that is used to determine
the luminance threshold of the background color for text color.}

\item{method}{A character string that specifies the method for calculating
the luminance. Three different methods are available:
c("relative","perceived","perceived_2")}
}
\value{
A character string that contains the best contrast text color.
}
\description{
Calculates the best contrast text color for a given
background color.
}
\details{
This function aids in deciding the font color to print on a given background.
The function is based on the example provided by teppo:
https://stackoverflow.com/a/66669838/21019325.
The different methods provided are based on the methods outlined in the
StackOverflow thread:
https://stackoverflow.com/questions/596216/formula-to-determine-perceived-brightness-of-rgb-color
}
\examples{
contrast_text(c("#F2F2F2", "blue"))

contrast_text(c("#F2F2F2", "blue"), method="relative")
}
