% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STVARconstruction.R
\name{swap_parametrization}
\alias{swap_parametrization}
\title{Swap the parametrization of a STVAR model}
\usage{
swap_parametrization(stvar, calc_std_errors = FALSE)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an S3 object of class \code{'stvar'} defining a smooth transition VAR model. The returned list
 contains the following components (some of which may be \code{NULL} depending on the use case):
   \item{data}{The input time series data.}
   \item{model}{A list describing the model structure.}
   \item{params}{The parameters of the model.}
   \item{std_errors}{Approximate standard errors of the parameters, if calculated.}
   \item{transition_weights}{The transition weights of the model.}
   \item{regime_cmeans}{Conditional means of the regimes, if data is provided.}
   \item{total_cmeans}{Total conditional means of the model, if data is provided.}
   \item{total_ccovs}{Total conditional covariances of the model, if data is provided.}
   \item{uncond_moments}{A list of unconditional moments including regime autocovariances, variances, and means.}
   \item{residuals_raw}{Raw residuals, if data is provided.}
   \item{residuals_std}{Standardized residuals, if data is provided.}
   \item{structural_shocks}{Recovered structural shocks, if applicable.}
   \item{loglik}{Log-likelihood of the model, if data is provided.}
   \item{IC}{The values of the information criteria (AIC, HQIC, BIC) for the model, if data is provided.}
   \item{all_estimates}{The parameter estimates from all estimation rounds, if applicable.}
   \item{all_logliks}{The log-likelihood of the estimates from all estimation rounds, if applicable.}
   \item{which_converged}{Indicators of which estimation rounds converged, if applicable.}
   \item{which_round}{Indicators of which round of optimization each estimate belongs to, if applicable.}
   \item{seeds}{The seeds used in the estimation in \code{fitSTVAR}, if applicable.}
   \item{LS_estimates}{The least squares estimates of the parameters in the form
     \eqn{(\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\alpha} (intercepts replaced by unconditional means
     if mean parametrization is used), if applicable.}
}
\description{
\code{swap_parametrization} swaps the parametrization of a STVAR model
 to \code{"mean"} if the current parametrization is \code{"intercept"}, and vice versa.
}
\details{
\code{swap_parametrization} is a convenient tool if you have estimated the model in
 "intercept" parametrization but wish to work with "mean" parametrization in the future, or vice versa.
}
\examples{
## Create a Gaussian STVAR p=1, M=2 model with the weighted relative stationary densities
# of the regimes as the transition weight function; use the intercept parametrization:
theta_122relg <- c(0.734054, 0.225598, 0.705744, 0.187897, 0.259626, -0.000863,
  -0.3124, 0.505251, 0.298483, 0.030096, -0.176925, 0.838898, 0.310863, 0.007512,
  0.018244, 0.949533, -0.016941, 0.121403, 0.573269)
mod122 <- STVAR(p=1, M=2, d=2, params=theta_122relg, parametrization="intercept")
mod122$params[1:4] # The intercept parameters

# Swap from the intercept parametrization to mean parametrization:
mod122mu <- swap_parametrization(mod122)
mod122mu$params[1:4] # The mean parameters

# Swap back to the intercept parametrization:
mod122int <- swap_parametrization(mod122mu)
mod122int$params[1:4] # The intercept parameters

## Create a linear VAR(p=1) model with the intercept parametrization, include
# the two-variate data gdpdef to the model and calculate approximate standard errors:
theta_112 <- c(0.649526, 0.066507, 0.288526, 0.021767, -0.144024, 0.897103,
  0.601786, -0.002945, 0.067224)
mod112 <- STVAR(data=gdpdef, p=1, M=1, params=theta_112, parametrization="intercept",
  calc_std_errors=TRUE)
print(mod112, standard_error_print=TRUE) # Standard errors are printed for the intercepts

# To obtain standard errors for the unconditional means instead of the intercepts,
# swap to mean parametrization:
mod112mu <- swap_parametrization(mod112, calc_std_errors=TRUE)
print(mod112mu, standard_error_print=TRUE) # Standard errors are printed for the means
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hubrich K., Teräsvirta. T. 2013. Thresholds and Smooth Transitions in Vector Autoregressive Models.
     \emph{CREATES Research Paper 2013-18, Aarhus University.}
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{Econometric Reviews}, \strong{39}:4, 407-414.
   \item Lütkepohl H., Netšunajev A. 2017. Structural vector autoregressions with smooth transition in variances.
     \emph{Journal of Economic Dynamics & Control}, \strong{84}, 43-57.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
