% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-general.R
\name{newtonRaphson}
\alias{newtonRaphson}
\title{Find roots using Newton-Raphson algorithm}
\usage{
newtonRaphson(f, df, start = 0, atol = 1e-04, rtol = 1e-04,
  maxit = 10000, ...)
}
\arguments{
\item{f}{a numeric valued function from a single numeric argument.}

\item{df}{the derivative of `f`.}

\item{start}{numerical value. The initial position for the Newton Raphson
iteration.}

\item{atol}{numeric value. The absolute tolerence for finding a root.}

\item{rtol}{numeric value. The relative tolerence for finding a root.}

\item{maxit}{an integer value. The maximal number of iterations.}

\item{...}{additional parameters to be passed to `f`.}
}
\value{
a numeric value, the root.
}
\description{
find root of a function using the Newton Raphson algorithm.
}
