% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio-base.R
\name{generateExpression.portfolio}
\alias{generateExpression.portfolio}
\title{Generate the Market Valuation Expression for a Portfolio}
\usage{
\method{generateExpression}{portfolio}(object, market.item.types, market.risk,
  standalone = NULL, ...)
}
\arguments{
\item{object}{S3 object of class portfolio.}

\item{market.item.types}{character value indicating the item classes
for which the market expression should be computed and aggregated, this should be a
subset of the following values:
\itemize{
  \item asset
  \item cashflow
  \item liability
  \item assetForward
  \item fxForward
  \item delta
}
you can also provide the value "all", in this case all market item expressions
in the portfolio are computed and aggregated.}

\item{market.risk}{S3 object of class marketRisk.}

\item{standalone}{S3 object of class standalone.}

\item{...}{additional arguments.}
}
\value{
a character value, the market expression.
}
\description{
method to generate the market valuation expression for a given
  portfolio and a given subset of item classes.
}
\note{
Please consider that the expression are centered (mean zero).
}
\seealso{
\code{\link{portfolio}}.
}
