% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta-base.R
\name{delta}
\alias{delta}
\title{Constructing a Delta-Normal Remainder Term
with Respect to MarketRisk}
\usage{
delta(name, currency, sensitivity)
}
\arguments{
\item{name}{numeric value. The names of the market base risk factors (the base risk factors defined in \code{marketRisk})
with respect to which sensitivities are computed (non-zero). This vector should not contain duplicated names.}

\item{currency}{character value representing currencies in which the
sensitivities are expressed. If the currency specified does not match the
base currency of the \code{marketRisk}, the initial
fx-rates will be used to convert to the base currency. Nevertheless, it is forced at construction of
a \code{portfolio} that the sensitivities should be provided in the the \code{portfolio} base
currency.}

\item{sensitivity}{numeric value giving sensitivities
for the corresponding market risk-factors provided in \code{name}. These quantities explicitely relates
to the \emph{"Sensitivität"} as defined in the FINMA technical document
\emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}, you can refer
to this document for their estimation procedures. Sensitivities must be expressed
in the corresponding currencies, i.e. in \code{currency}.}
}
\value{
an S3 object, instance of the class delta.
}
\description{
\code{delta} Constructor for the S3 class delta.
  It allows to build for the sensitivities with respect to the market risk-factors
  of the total positions not modelled by the other \code{marketItem} classes
  used in a delta-normal remainder term presented in the FINMA technical document
  \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\note{
All parameters must be of equal length.
}
\examples{
# Creating a new delta.
d <- delta(name        = c("equity", "2YCHF", "EURCHF"),
           currency    = c("EUR", "CHF", "EUR"),
           sensitivity = c(100, 150, 130))

}
\seealso{
\code{\link{summary.delta}}, \code{\link{print.delta}}.
}
