% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA_S4_all_classes_definitions.R
\docType{class}
\name{sspm_dataset-class}
\alias{sspm_dataset-class}
\title{sspm dataset structure}
\description{
One of the first step in the \code{sspm} workflow is to create one or more
object(s) of class \code{sspm_dataset} from a \code{data.frame}, \code{tibble} or \code{sf} object.
}
\section{Slots}{

\describe{
\item{\code{name}}{\strong{[character]} The name of the dataset, default to "Biomass".}

\item{\code{data}}{\strong{[data.frame OR sf OR tibble]} The dataset.}

\item{\code{biomass}}{\strong{[character]} The biomass columns of \code{data}.}

\item{\code{density}}{\strong{[character]} The biomass density columns of \code{data}.}

\item{\code{time}}{\strong{[character]} The column of \code{data} that represents the
temporal dimension of the dataset.}

\item{\code{coords}}{\strong{[character]} The columns of \code{data} that represent the
spatial dimension of the dataset: the two columns for longitude and
latitude of the observations.}

\item{\code{uniqueID}}{\strong{[character]} The column of \code{data} that is unique for all
rows of the data matrix.}

\item{\code{boundaries}}{\strong{[sspm_discrete_boundary]} Spatial boundaries (polygons).}

\item{\code{formulas}}{\strong{[list]} List of
\link[=sspm_formula-class]{sspm_formula} objects that specifies the smoothed
variables.}

\item{\code{smoothed_data}}{\strong{[ANY (sf)]} The smoothed data.}

\item{\code{smoothed_vars}}{\strong{[character]} A vector storing the smoothed vars.}

\item{\code{smoothed_fit}}{\strong{[list]} The fit from smoothing the data}

\item{\code{is_mapped}}{\strong{[logical]} Whether the dataset has been mapped to
boundaries (used internally).}
}}

