% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{ssd_is_censored}
\alias{ssd_is_censored}
\alias{ssd_is_censored.data.frame}
\alias{ssd_is_censored.fitdists}
\title{Is Censored}
\usage{
ssd_is_censored(x, ...)

\method{ssd_is_censored}{data.frame}(x, left = "Conc", right = left, ...)

\method{ssd_is_censored}{fitdists}(x, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}
}
\value{
A flag indicating whether an object is censored.
}
\description{
Tests if an object has censored data.

Test if a data frame is censored.

Test if a fitdists object is censored.
}
\examples{

ssd_is_censored(ssddata::ccme_boron)
ssd_is_censored(data.frame(Conc = 1, right = 2), right = "right")

fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_is_censored(fits)
}
