% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz}
\alias{gompertz}
\alias{dgompertz}
\alias{pgompertz}
\alias{qgompertz}
\alias{rgompertz}
\alias{sgompertz}
\title{Gompertz Distribution}
\usage{
dgompertz(x, llocation = 0, lshape = 0, log = FALSE)

pgompertz(q, llocation = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

qgompertz(p, llocation = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

rgompertz(n, llocation = 0, lshape = 0)

sgompertz(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{llocation}{location parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dgompertz(x), type = "l")
}
\seealso{
\code{\link[stats:GammaDist]{stats::dgamma()}}
}
