% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_ssm.R
\name{evaluate_ssm}
\alias{evaluate_ssm}
\title{Evaluate the adequacy of the state-space model to reproduce the observed data}
\usage{
evaluate_ssm(ssmfit = NULL, M = 100, plotx = TRUE)
}
\arguments{
\item{ssmfit}{(list) output of \code{\link{run_ssm}} function}

\item{M}{(integer) number of replications}

\item{plotx}{(boolean) if \code{plotx=TRUE} the function returns a graphical representation for the fit indices}
}
\value{
a datalist containing the adequacy indices
}
\description{
Evaluate the adequacy of the state-space model to reproduce the observed data
}
\details{
The function implements a simulated-based method for assessing the adequacy of the model to reproduce the observed data. In particular,
the function provides two type of model adequacy, i.e. overall (PA_ov) and by-subject (PA_sbj). In the overall case the function provides the total amount of data reconstruction 
based on the I x J x N matrix Y of observed data. By contrast, in the second case the function provides the adequacy of the model to reconstruct the individual-based set of data
as it works on the matrix J x N over i=1,...,I. Both the indices are in the range 0\% - 100\%, with 100\% indicating perfect fit. In addition, the function returns a by-subject distance-based index (Dynamic Timw Warp distance) between observed and reproduced trajectories using \code{\link[dtw:dtw]{dtw}} function.
}
\examples{

\dontrun{
## Fit a state-space model using simulated data 
# Generate mouse-tracking data for an univariate experimental design with K = 3 categorical levels, 
## J = 12 trials, I = 5 subjects
X1 <- generate_data(I=5,J=12,K=3,Z.formula="~Z1")
iid <- 23 # keep just one dataset from the simulated set of datasets
# Run the state-space model on the chosen dataset
X1_fit <- run_ssm(N = X1$N,I = X1$I,J = X1$J,Y = X1$data$Y[iid,,],D = X1$data$D[iid,,],
Z = X1$data$Z,niter=100,nwarmup=25)
# Evaluate the state-space model
evaluate_ssm(ssmfit = X1_fit,M = 10,plotx=FALSE)
}
}
