% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_tuning.R
\name{parameter_tuning}
\alias{parameter_tuning}
\title{Parameter Tuning}
\usage{
parameter_tuning(
  data,
  coords,
  N_assignments,
  lambda = c(0, 0.25, 0.5, 0.75, 0.9),
  weights = NULL,
  k = NULL,
  dist = NULL,
  cont = 0.05,
  repetitions = 5
)
}
\arguments{
\item{data}{matrix with observations.}

\item{coords}{matrix of coordinates of these observations.}

\item{N_assignments}{numeric vector, the neighborhood structure that should be used for \code{\link[ssMRCD]{ssMRCD}}.}

\item{lambda}{scalar, the smoothing parameter.}

\item{weights}{weighting matrix used in \code{\link[ssMRCD]{ssMRCD}}.}

\item{k}{vector of possible k-values to evaluate.}

\item{dist}{vector of possible dist-values to evaluate.}

\item{cont}{level of contamination, between 0 and 1.}

\item{repetitions}{number of repetitions wanted to have a good picture of the best parameter combination.}
}
\value{
Returns a matrix of average false-negative rate (FNR) values and the total number of outliers found by the method as aproxy for the false-positive rate.
Be aware that the FNR does not take into account that there are also natural outliers included in the data set that might or might not be found.
Also a plot is returned representing these average.
The best parameter selection depends on the goal of the analysis.
}
\description{
This function provides insight into the effects of different parameter settings.
}
\examples{
\donttest{
# get data set
data("weatherAUT2021")

# make neighborhood assignments
cut_lon = c(9:16, 18)
cut_lat = c(46, 47, 47.5, 48, 49)
N = ssMRCD::N_structure_gridbased(weatherAUT2021$lon, weatherAUT2021$lat, cut_lon, cut_lat)
table(N)
N[N == 2] = 1
N[N == 3] = 4
N[N == 5] = 4
N[N == 6] = 7
N[N == 11] = 15
N = as.numeric(as.factor(N))

# tune parameters
set.seed(123)
parameter_tuning(data = weatherAUT2021[, 1:6 ],
                 coords = weatherAUT2021[, c("lon", "lat")],
                 N_assignments = N,
                 lambda = c(0.5, 0.75),
                 k = c(10),
                 repetitions = 1)
}
}
