% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srp_l.R
\name{srp.l}
\alias{srp.l}
\title{The (simpler) Smooth-Rough Partition linear regression model fitting}
\usage{
srp.l(x, y, maxq = 10, plot = T)
}
\arguments{
\item{x}{A matrix you wish to fit Smooth-Rough Partition model. The dimension of row is the number of variables.}

\item{y}{A vector you wish to use as a response variable in case of regressing \code{y} on \code{x}. If \code{y} is missing, the response variable is obtained in design matrix \code{x}.}

\item{maxq}{An integer specifying the maximum value of number of unconstrained parameters which the model can have. The default is 10.}

\item{plot}{If true, it gives the plot of estimated regression coefficients.}
}
\value{
\item{muhat}{The estimator of constant parameter.}
\item{bhat}{The vector of evaluated constrained (linear) functional regression coefficient.}
\item{ahat}{The vector of unconstrained regression coefficcient estimators.}
\item{etahat}{The vector containing both \code{bhat} and \code{ahat} with unevaluated form.}
\item{yhat}{The vector of estimated response variable.}
\item{SIC}{The vector of Schwarz criterion with length \code{maxq} which is computed for different number of unconstrained parameters.}
\item{qhat}{The optimal number of unconstrained parameters selected in the model.}
}
\description{
This function performs same as \code{\link{srp.c}} except that constrained functional coefficient is estimated as a linear function.
}
\details{
The estimation procedure of Smooth-Rough Partition model is described in "Regularised forecasting via smooth-rough partitioning of the regression coefficients", H. Maeng and P. Fryzlewicz (2018), preprint.
}
\examples{
x <- matrix(rnorm(10000), ncol=100)
srp.l(x)
}
\seealso{
\code{\link{srp.c}}
}
\author{
Hyeyoung Maeng, \email{h.maeng@lse.ac.uk}
}
