% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squids_to_datetime.R, R/squids_to_timestamp.R
\name{squids_to_datetime}
\alias{squids_to_datetime}
\alias{squids_to_timestamp}
\title{Converting SQUIDs back to timestamps and dates/times}
\usage{
squids_to_datetime(x, tz = "UTC")

squids_to_timestamp(x)
}
\arguments{
\item{x}{A vector of one or more SQUIDs}

\item{tz}{The timezone to use}
}
\value{
A vector of one or more timestamps or \code{POSIXct} date/time objects
}
\description{
Converting SQUIDs back to timestamps and dates/times
}
\examples{
exampleSQUID <-
  squids::squids();

### Timestamp (second since UNIX Epoch,
###            1970-01-01, 00:00:00 UTC)
squids::squids_to_timestamp(
  exampleSQUID
);

squids::squids_to_datetime(
  exampleSQUID
);

### In Central European Time
squids::squids_to_datetime(
  exampleSQUID,
  tz = "CET"
);
}
