% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squids.R, R/timestamp_to_squids.R
\name{squids}
\alias{squids}
\alias{timestamp_to_squids}
\title{Generate short quasi-unique identifiers (SQUIDs)}
\usage{
squids(x, origin = Sys.time(), follow = NULL, followBy = NULL)

timestamp_to_squids(x)
}
\arguments{
\item{x}{The number of identifiers to generate.}

\item{origin}{The origin to use when generating the actual
identifiers. These identifiers are the present UNIX timestamp
(i.e. the number of seconds elapsed since the UNIX epoch,
the first of january 1970), accurate to two decimal places
(i.e. to centiseconds), converted to the base 30 system using
\code{\link[=numericToBase30]{numericToBase30()}}. By default, the present time is used as
origin, one one centisecond is added for every identifiers to
generate. \code{origin} can be set to other values to work with
different origins (of course, don't use this unless you
understand very well what you're doing!).}

\item{follow}{A vector of one or more SQUIDs (or a list; lists are
recursively \code{unlist()}ed); the highest SQUID will be taken, converted
to a timestamp, and used as \code{origin} (well, 0.01 second later), so that the
new SQUIDs will follow that sequence.}

\item{followBy}{When following a vector of SQUIDs, this can be used to
specify the distance between the two vectors in centiseconds.}
}
\value{
A vector of SQUIDs.
}
\description{
This function generates short quasi-unique identifiers.
}
\details{
SQUIDs are defined as 8-character strings that express a timestamp (the
number of centiseconds that passed since the UNIX Epoch) in a base 30
decimal system. The lowest possible SQUID, therefore, is \code{00000001} (which
corresponds to 1970-01-01 00:00:00 UTC), and the highest possible SQUID is
\code{zzzzzzzz}, which corresponds to 2177-11-28 11:59:59 UTC.
}
\examples{
exampleSQUIDs <-
  squids::squids(5);

### Show how SQUIDs are the converted date/time
squids::squids_to_datetime(
  exampleSQUIDs
);

### These seem the same, but if we take these as
### timestamps (seconds passed since the UNIX Epoch)
### and multiply with 100 to see the centiseconds,
### we see the differences:
as.numeric(
  squids::squids_to_datetime(
    exampleSQUIDs
  )
) * 100;

### Get a sequence following the first one
squids::squids(5, follow=exampleSQUIDs);

### Follow at a distance
squids::squids(
  5,
  follow=exampleSQUIDs,
  followBy = 3
);
}
