% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-sample-class.R
\name{rnorm_qts}
\alias{rnorm_qts}
\title{QTS Random Sampling}
\usage{
rnorm_qts(n, mean_qts, alpha = 0.01, beta = 0.001)
}
\arguments{
\item{n}{An integer specifying how many QTS should be generated.}

\item{mean_qts}{An object of class \code{\link{qts}} specifying the mean QTS.}

\item{alpha}{A positive scalar specifying the variance of each component of
the log-QTS. Defaults to \code{0.01}.}

\item{beta}{A positive scalar specifying the exponential weight. Defaults to
\code{0.001}.}
}
\value{
A list of \code{n} objects of class \code{\link{qts}} with added noise as
specified by parameters \code{alpha} and \code{beta}.
}
\description{
This function adds uncorrelated Gaussian noise to the logarithm QTS using an
exponential covariance function.
}
\details{
See \code{\link[roahd]{exp_cov_function}} for details about the roles of
\code{alpha} and \code{beta} in the definition of the covariance operator.
}
\examples{
rnorm_qts(1, vespa64$igp[[1]])
}
