% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{moving_average}
\alias{moving_average}
\alias{moving_average.qts}
\alias{moving_average.qts_sample}
\title{QTS Moving Average}
\usage{
moving_average(x, window_size = 0)

\method{moving_average}{qts}(x, window_size = 0)

\method{moving_average}{qts_sample}(x, window_size = 0)
}
\arguments{
\item{x}{An object of class \code{\link{qts}} or \code{\link{qts_sample}}.}

\item{window_size}{An integer value specifying the size of the sliding window
used to compute the median value. Defaults to \code{0L}.}
}
\value{
An object of the same class as the input argument \code{x} storing the
smoothed QTS.
}
\description{
This function performs QTS smoothing via moving average.
}
\examples{
moving_average(vespa64$igp[[1]], window_size = 5)
moving_average(vespa64$igp, window_size = 5)
}
