% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTW.R
\name{DTW}
\alias{DTW}
\title{Dynamic Time Warping for Quaternion Time Series}
\usage{
DTW(
  qts1,
  qts2,
  resample = TRUE,
  disable_normalization = FALSE,
  distance_only = FALSE,
  step_pattern = dtw::symmetric2
)
}
\arguments{
\item{qts1}{An object of class \link{qts}.}

\item{qts2}{An object of class \link{qts}.}

\item{resample}{A boolean specifying whether the QTS should be uniformly
resampled on their domain before computing distances. Defaults to \code{TRUE}.}

\item{disable_normalization}{A boolean specifying whether quaternion
normalization should be disabled. Defaults to \code{FALSE} which ensures that we
always deal with unit quaternions.}

\item{distance_only}{A boolean specifying whether to only compute distance
(no backtrack, faster). Defaults to \code{FALSE}.}

\item{step_pattern}{A \link[dtw:stepPattern]{dtw::stepPattern} specifying the local constraints on
the warping path. Defaults to \link[dtw:stepPattern]{dtw::symmetric2} which uses symmetric and
normalizable warping paths with no local slope constraints. See
\link[dtw:stepPattern]{dtw::stepPattern} for more information.}
}
\value{
An object of class \link[dtw:dtw]{dtw::dtw} storing the dynamic time warping
results.
}
\description{
This function evaluates the Dynamic Time Warping (DTW) distance between two
quaternion time series (QTS).
}
\details{
If no evaluation grid is provided, the function assumes that the two input
QTS are evaluated on the same grid.
}
\examples{
DTW(vespa64$igp[[1]], vespa64$igp[[2]])
}
