% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsurvey.R
\docType{package}
\name{spsurvey-package}
\alias{spsurvey}
\alias{spsurvey-package}
\title{spsurvey: Spatial Sampling Design and Analysis}
\description{
spsurvey implements a design-based approach to statistical inference,
  with a focus on spatial data.
  Spatially balanced samples are selected using the
  Generalized Random Tessellation Stratified (GRTS) algorithm.
  The GRTS algorithm can be applied to finite resources (point geometries) and
  infinite resources (linear / linestring and areal / polygon geometries) and flexibly
  accommodates a diverse set of sampling design features, including
  stratification, unequal inclusion probabilities, proportional (to size)
  inclusion probabilities, legacy (historical) sites, a minimum distance between
  sites, and two options for replacement sites (reverse hierarchical order and
  nearest neighbor). Data are analyzed using a wide
  range of analysis functions that perform categorical variable analysis, continuous
  variable analysis, attributable risk analysis, risk difference analysis, relative
  risk analysis, change analysis, and trend analysis. spsurvey can also be used to
  summarize objects, visualize objects, select samples that are not spatially balanced,
  select panel samples, measure the amount of spatial balance in a sample,
  adjust design weights, and more.
  This R package has been reviewed in accordance
  with U.S. Environmental Protection Agency policy and approved for publication.
  Mention of trade names or commercial products does not constitute endorsement or
  recommendation for use.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://usepa.github.io/spsurvey/}
  \item \url{https://github.com/USEPA/spsurvey}
  \item Report bugs at \url{https://github.com/USEPA/spsurvey/issues}
}

}
\author{
\strong{Maintainer}: Michael Dumelle \email{Dumelle.Michael@epa.gov} (\href{https://orcid.org/0000-0002-3393-5529}{ORCID})

Authors:
\itemize{
  \item Tom Kincaid \email{Kincaid.Tom@epa.gov}
  \item Tony Olsen \email{Olsen.Tony@epa.gov}
  \item Marc Weber \email{Weber.Marc@epa.gov}
}

Other contributors:
\itemize{
  \item Don Stevens [contributor]
  \item Denis White [contributor]
}

}
