% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbcsamp.R
\name{sbcsamp}
\alias{sbcsamp}
\title{Calculate Spatial Balance Grid Cell Extent and Proportions for a Survey Design}
\usage{
sbcsamp(spsample, sbc.frame = NULL, dx = NULL, dy = NULL,
  xc = NULL, yc = NULL)
}
\arguments{
\item{spsample}{Object of class SpatialDesign produced by either the grts or
irs functions that contains survey design information and additional
attribute (auxiliary) variables.}

\item{sbc.frame}{The object created by the sbcframe function.  The default is
NULL.}

\item{dx}{Grid cell x-coordinate increment value.  The default is NULL.}

\item{dy}{Grid cell y-coordinate increment value.  The default is NULL.}

\item{xc}{Vector of grid cell x-coordinates.  The default is NULL.}

\item{yc}{Vector of grid cell y-coordinates.  The default is NULL.}
}
\value{
List containing the following components:
  \describe{
    \item{extent}{the sample extent for each grid cell}
    \item{prop}{the sample proportion for each grid cell}
  }
}
\description{
This function calculates spatial balance grid cell extent and proportions
for a survey design.  The user must provide either sbc.frame or values for
dx, dy, xc, and yc.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
