% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_spsur.R
\name{methods_spsur}
\alias{methods_spsur}
\alias{anova}
\alias{anova.spsur}
\alias{coef}
\alias{coef.spsur}
\alias{fitted}
\alias{fitted.spsur}
\alias{logLik}
\alias{logLik.spsur}
\alias{residuals}
\alias{residuals.spsur}
\alias{vcov}
\alias{vcov.spsur}
\alias{print}
\alias{print.spsur}
\alias{plot}
\alias{plot.spsur}
\title{Methods for class spsur}
\usage{
\method{anova}{spsur}(object, ..., lrtest = TRUE)

\method{coef}{spsur}(object, ...)

\method{fitted}{spsur}(object, ...)

\method{logLik}{spsur}(object, ...)

\method{residuals}{spsur}(object, ...)

\method{vcov}{spsur}(object, ...)

\method{print}{spsur}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{plot}{spsur}(x, ci = 0.95, viewplot = TRUE, ...)
}
\arguments{
\item{object}{a \code{spsur} object created by \code{\link{spsurml}},
\code{\link{spsur3sls}} or \code{\link{spsurtime}}.}

\item{...}{further arguments passed to or from other methods.}

\item{lrtest}{logical value to compute likelihood ratio
test for nested models in `anova` method. Default = \code{TRUE}}

\item{x}{similar to \code{object} argument for \code{print()} 
and \code{plot} functions.}

\item{digits}{number of digits to show in printed tables.
Default: max(3L, getOption("digits") - 3L).}

\item{ci}{confidence level for the intervals in `plot` method. 
Default \code{ci = 0.95}}

\item{viewplot}{logical value to show interactively the plots. 
Default = \code{TRUE}}
}
\description{
The \code{anova()} function provides tables of fitted 
 spsur models including information criteria (AIC and BIC), 
 log-likelihood and degrees of freedom of each fitted model. The 
 argument \code{lrtest} allows to perform LR tests between nested models.
 The \code{plot()} function allows the user to plot both beta and spatial
 coefficients for all equations of the spsur model. The argument 
 \code{viewplot} is used to choose between interactive or non-interactive
 plots. The \code{print()} function is used to print short tables including the values of beta and
 spatial coefficients as well as p-values of significance test for each 
 coefficient. This can be used as an alternative to 
 \code{\link{summary.spsur}} when a brief output is needed. 
 The rest of methods works in the usual way.
}
\examples{
rm(list = ls()) # Clean memory
data(spc)
Tformula <- WAGE83 | WAGE81 ~ UN83 + NMR83 + SMSA | UN80 + NMR80 + SMSA
spcsur.sim <-spsurml(formula = Tformula, data = spc, type = "sim")
## Print Table       
print(spcsur.sim)
\donttest{
spcsur.slm <-spsurml(formula = Tformula, data = spc, type = "slm", 
                     listw = Wspc)
# ANOVA table and LR test for nested models:
anova(spcsur.sim, spcsur.slm)
## Plot spatial and beta coefficients
# Interactive plot
plot(spcsur.slm)
# Non-interactive plot
if (require(gridExtra)) {
  pl <- plot(spcsur.slm, viewplot = FALSE) 
  grid.arrange(pl$lplbetas[[1]], pl$lplbetas[[2]], 
               pl$pldeltas, nrow = 3)
}
}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesús Mur  \tab \email{jmur@unizar.es} \cr
  }
}
