% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsur3sls.R
\name{spsur3sls}
\alias{spsur3sls}
\title{Three Stages Least Squares estimation,3sls, of spatial SUR models.}
\usage{
spsur3sls(Form = NULL, data = NULL, R = NULL, b = NULL, W = NULL,
  X = NULL, Y = NULL, G = NULL, N = NULL, Tm = NULL, p = NULL,
  demean = FALSE, type = "slm", maxlagW = 2)
}
\arguments{
\item{Form}{An object created with the package \code{\link[Formula]{Formula}}
that describes the model to be estimated. This model may contain several
responses (explained variables) and a varying number of regressors in each equation.}

\item{data}{An object of class data.frame or a matrix.}

\item{R}{A row vector of order \emph{(1xpr)} with  the set of \emph{r} linear constraints
on the \emph{beta} parameters. The \emph{first} restriction appears in the first \emph{p} terms,
the second restriction in the next \emph{p} terms and so on. Default = \code{NULL}.}

\item{b}{A column vector of order \emph{(rx1)} with the values of the linear restrictions on the
\emph{beta} parameters. Default = \code{NULL}.}

\item{W}{A spatial weighting matrix of order \emph{(NxN)}, assumed to be the
same for all equations and time periods.}

\item{X}{A data matrix of order \emph{(NTmGxp)} with the observations of the regressors
The number of covariates in the SUR model is p = \eqn{sum(p_{g})} where \emph{\eqn{p_{g}}}
is the number of regressors (including the intercept) in the g-th equation, \emph{g = 1,...,G}).
The specification of \emph{X} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame. Default = \code{NULL}.}

\item{Y}{A column vector of order \emph{(NTmGx1)}, with the observations of the
explained variables. The ordering of the data must be (first) equation,
(second) time dimension and (third) Cross-sectional/spatial units.
The specification of \emph{Y} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame. Default = \code{NULL}.}

\item{G}{Number of equations.}

\item{N}{Number of cross-section or spatial units}

\item{Tm}{Number of time periods.}

\item{p}{Number of regressors by equation, including the intercept. \emph{p} can be a row
vector of order \emph{(1xG)}, if the number of regressors is not the same for all the
equations, or a scalar, if the \emph{G} equations have the same number of regressors.
The specification of \emph{p} is only necessary if not available a \code{\link[Formula]{Formula}}
and a data frame.}

\item{demean}{Logical value to allow for the demeaning of panel data. In this case,
\code{\link{spsurml}} substracts the individual mean to each spatial or cross-sectional
unit. Default = \code{FALSE}.}

\item{type}{Type of spatial model, restricted to cases where lags of the explainded variable appear
in the righ hand side of the equations. There are two possibilities: \strong{"slm"} or
\strong{"sdm"}. Default = "slm".}

\item{maxlagW}{Maximum spatial lag order of the regressors employed to produce spatial
instruments for the spatial lags of the explained variables. Default = 2. Note that in case of
\emph{type="sdm"}, the default value for maxlagW is set to 3 because the first lag of the
regressors, \eqn{WX_{tg}}, can not be used as spatial instruments.}
}
\value{
Output of the  three-stages Least-Squares estimation of the specified spatial model.
  A list with:
  \tabular{ll}{
    \code{call} \tab Matched call. \cr
    \code{type} \tab  Type of model specified. \cr
    \code{betas} \tab Estimated coefficients for the regressors. \cr
    \code{deltas} \tab Estimated spatial coefficients. \cr
    \code{se_betas} \tab Estimated standard errors for the estimates of \emph{\eqn{\beta}} coefficients. \cr
    \code{se_deltas} \tab Estimated standard errors for the estimates of the spatial coefficients. \cr
    \code{cov} \tab Estimated covariance matrix for the estimates of \emph{beta's} and spatial coefficients.\cr
    \code{R2} \tab Coefficient of determination for each equation, obtained as the squared
     of the correlation coefficient between the corresponding explained variable and
      its estimates. \emph{spsur3sls} also shows a \emph{global} coefficient of
       determination obtained, in the same manner, for the set of \emph{G} equations. \cr
    \code{Sigma} \tab Estimated covariance matrix for the residuals of the \emph{G} equations. \cr
    \code{Sigma_corr} \tab Estimated correlation matrix for the residuals of the \emph{G} equations. \cr
    \code{Sigma_inv} \tab Inverse of \code{Sigma}, the \emph{(GxG)} covariance matrix of
     the residuals of the SUR model. \cr
    \code{residuals} \tab Residuals of the model. \cr
    \code{df.residuals} \tab Degrees of freedom for the residuals. \cr
    \code{fitted.values} \tab Estimated values for the dependent variables. \cr
    \code{G} \tab Number of equations. \cr
    \code{N} \tab Number of cross-sections or spatial units. \cr
    \code{Tm} \tab Number of time periods. \cr
    \code{p} \tab Number of regressors by equation (including intercepts). \cr
    \code{demean} \tab Logical value used for demeaning. \cr
    \code{Y} \tab Vector \emph{Y} of the explained variables of the SUR model. \cr
    \code{X} \tab Matrix \emph{X} of the regressors of the SUR model. \cr
    \code{W} \tab Spatial weighting matrix. \cr
 }
}
\description{
The function estimates spatial SUR models using three stages
 least squares, where the instruments are obtained from the spatial lags
 of the \emph{X} variables, assumed to be exogenous. The number of equations, time periods
 and spatial units is not restricted. The user can choose between a Spatial Durbin Model
 or a Spatial Lag Model, as described below. The estimation procedure allows for the introduction
 of linear restrictions on the \eqn{\beta} parameters associated to the regressors.
}
\details{
\emph{spsur3sls} can be used to estimate two groups of spatial models:
  \itemize{
    \item \strong{"slm"}: SUR model with spatial lags of the endogenous in the right hand
    side of the equations
      \deqn{y_{tg} = \lambda_{g} Wy_{tg} + X_{tg} \beta_{g} + \epsilon_{tg} }
    \item \strong{"sdm"}: SUR model of the Spatial Durbin type
      \deqn{ y_{tg} = \lambda_{g} Wy_{tg} + X_{tg} \beta_{g} +
             WX_{tg} \theta_{g} + \epsilon_{tg} }
             }

  where \eqn{y_{tg}} and \eqn{\epsilon_{tg}} are \emph{(Nx1)} vectors,
  corresponding to the g-th equation and time period t; \eqn{X_{tg}} is the matrix
  of regressors, of order \emph{(Nxp_{g})}. Moreover, \eqn{\lambda_{g}} is a
  spatial coefficient and \emph{W} is a \emph{(NxN)} spatial weighting matrix.

 By default, the input of this function is an object created with \code{\link[Formula]{Formula}} and
 a data frame. However, \emph{spsur3sls} also allows for the direct especification of vector
 \emph{Y} and matrix \emph{X}, with the explained variables and  regressors respectively, as
 inputs (these terms may be the result, for example, of \code{\link{dgp_spsur}}). \cr


 \emph{spsur3sls} is a Least-Squares procedure in three-stages designed to circumvent
  the endogeneity problems due to the presence of spatial lags of the explained variable
  in the right hand side of the equations do the SUR. The instruments are produced internally
  by \emph{spsur3sls} using a sequence of spatial lags of the \emph{X} variables, which are assumed
  to be exogenous. The user must define the number of (spatial) instruments to be used in the
  procedure, through the argument \emph{maxlagW} (i.e. maxlagW=3). Then, the collection of
  instruments generated is \eqn{[WX_{tg}; W*WX_{tg}; W*W*WX_{tg}]}. In the case of a \emph{SDM},
  the first lag of the \emph{X} matrix already is in the equation and cannot be used as instrument.
  In the example above, the list of instruments for a \emph{SDM} model would be
  \eqn{[W^{2}X_{tg}; W^{3}X_{tg}]}.

  The \emph{first} stage of the procedure consists in the least squares of the \emph{Y} variables
  on the set of instruments. From this estimation, the procedure retains the estimates of \emph{Y}
  in the so-called \emph{Yls} variables. In the \emph{second} stage, the \emph{Y} variables that
  appear in the right hand side of the equation are substituted by \emph{Yls} and the SUR model
  is estimated by Least Squares. The \emph{third} stage improves the estimates of the second stage
  through a Feasible Generalized Least Squares estimation of the parameters of the model,
  using the residuals of the \emph{second} stage to estimate the \emph{Sigma} matrix.


 The arguments \emph{R} and \emph{b} allows to introduce linear restrictions on the \emph{beta}
 coefficients of the \emph{G} equations. \code{\link{spsur3sls}}, first, introduces the
 linear restrictions in the SUR model and builds, internally, the corresponding constrained
 SUR model. Then, the function estimates the restricted model which is shown in the output.
 The function does not compute the unconstrained model nor test for the linear restrictions.
 The user may ask for the unconstrained estimation using another \code{\link{spsurml}}
 estimation. Moreover, the function \code{\link{wald_betas}} obtains the Wald test
 of a set of linear restrictions for an object created previously
 by \code{\link{spsurml}} or \code{\link{spsur3sls}}.
}
\examples{

#################################################
######## CROSS SECTION DATA (G=1; Tm>1) ########
#################################################

#### Example 1: Spatial Phillips-Curve. Anselin (1988, p. 203)
## A SUR model without spatial effects
rm(list = ls()) # Clean memory
data(spc)
Tformula <- WAGE83 | WAGE81 ~ UN83 + NMR83 + SMSA | UN80 + NMR80 + SMSA

## A SUR-SLM model (3SLS Estimation)
spcsur.slm.3sls <-spsur3sls(Form = Tformula, data = spc,
                            type = "slm", W = Wspc)
summary(spcsur.slm.3sls)

## A SUR-SDM model (3SLS Estimation)
spcsur.sdm.3sls <-spsur3sls(Form = Tformula, data = spc,
                            type = "sdm", W = Wspc)
summary(spcsur.sdm.3sls)

#################################################
######## PANEL DATA (G>1; Tm>1)         #########
#################################################

#### Example 2: Homicides + Socio-Economics (1960-90)
# Homicides and selected socio-economic characteristics for continental
# U.S. counties.
# Data for four decennial census years: 1960, 1970, 1980 and 1990.
# https://geodacenter.github.io/data-and-lab/ncovr/
rm(list = ls()) # Clean memory
data(NCOVR)
Tformula <- HR80  | HR90 ~ PS80 + UE80 | PS90 + UE90

## A SUR-SLR model
NCOVRSUR.slm.3sls <-spsur3sls(Form = Tformula, data = NCOVR, type = "slm",
                            W = W, maxlagW = 2)
summary(NCOVRSUR.slm.3sls)

}
\references{
\itemize{
    \item Mur, J., López, F., and Herrera, M. (2010). Testing for spatial
      effects in seemingly unrelated regressions.
      \emph{Spatial Economic Analysis}, 5(4), 399-440.
     \item López, F.A., Mur, J., and Angulo, A. (2014). Spatial model
       selection strategies in a SUR framework. The case of regional
       productivity in EU. \emph{Annals of Regional Science}, 53(1),
       197-220.
  }
}
\seealso{
\code{\link{spsurml}}, \code{\link{wald_betas}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesús Mur  \tab \email{jmur@unizar.es} \cr
  }
}
