% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimMKV.R
\name{optimMKV}
\alias{MKV}
\alias{objMKV}
\alias{optimMKV}
\title{Optimization of sample configurations for spatial interpolation (II)}
\usage{
optimMKV(points, candi, covars, eqn = z ~ 1, vgm, krige.stat = "mean", ...,
  schedule = scheduleSPSANN(), plotit = FALSE, track = FALSE, boundary,
  progress = "txt", verbose = FALSE)

objMKV(points, candi, covars, eqn = z ~ 1, vgm, krige.stat = "mean", ...)
}
\arguments{
\item{points}{Integer value, integer vector, data frame or matrix. If \code{points} is an integer value, 
it defines the number of points that should be randomly sampled from \code{candi} to form the starting 
system configuration. If \code{points} is a vector of integer values, it contains the row indexes of 
\code{candi} that correspond to the points that form the starting system configuration. If \code{points} 
is a data frame or matrix, it must have three columns in the following order: \code{[, "id"]} the row 
indexes of \code{candi} that correspond to each point, \code{[, "x"]} the projected x-coordinates, and 
\code{[, "y"]} the projected y-coordinates. Note that in the later case, \code{points} must be a subset 
of \code{candi}.}

\item{candi}{Data frame or matrix with the candidate locations for the jittered points. \code{candi} must 
have two columns in the following order: \code{[, "x"]} the projected x-coordinates, and \code{[, "y"]} the 
projected y-coordinates.}

\item{covars}{Data frame or matrix with the covariates in the columns.}

\item{eqn}{Formula string that defines the dependent variable \code{z} as a linear model of the independent 
variables contained in \code{covars}. Defaults to \code{eqn = z ~ 1}, that is, ordinary kriging. See the 
argument \code{formula} in the function \code{\link[gstat]{krige}} for more information.}

\item{vgm}{Object of class \code{variogramModel}. See the argument \code{model} in the function 
\code{\link[gstat]{krige}} for more information.}

\item{krige.stat}{Character value defining the statistic that should be used to summarize the kriging 
variance. Available options are \code{"mean"} and \code{"max"} for the mean and maximum kriging variance, 
respectively. Defaults to \code{krige.stat = "mean"}.}

\item{...}{further arguments passed to \code{\link[gstat]{krige}}.}

\item{schedule}{List with 11 named sub-arguments defining the control parameters of the cooling schedule. 
See \code{\link[spsann]{scheduleSPSANN}}.}

\item{plotit}{Logical for plotting the optimization results, including a) the progress of the objective
function, and b) the starting (gray) and current system configuration (black), and the maximum jitter in 
the x- and y-coordinates. The plots are updated at each 10 jitters. Defaults to \code{plotit = FALSE}.}

\item{track}{Logical value. Should the evolution of the energy state be recorded and returned with the 
result? If \code{track = FALSE} (the default), only the starting and ending energy states are returned with
the results.}

\item{boundary}{SpatialPolygon defining the boundary of the spatial domain. If missing and 
\code{plotit = TRUE}, \code{boundary} is estimated from \code{candi}.}

\item{progress}{Type of progress bar that should be used, with options \code{"txt"}, for a text progress 
bar in the R console, \code{"tk"}, to put up a Tk progress bar widget, and \code{NULL} to omit the progress
bar. A Tk progress bar widget is useful when using parallel processors. Defaults to 
\code{progress = "txt"}.}

\item{verbose}{Logical for printing messages about the progress of the optimization. Defaults to 
\code{verbose = FALSE}.}
}
\value{
\code{optimMKV} returns an object of class \code{OptimizedSampleConfiguration}: the optimized sample
configuration with details about the optimization.

\code{objMKV} returns a numeric value: the energy state of the sample configuration -- the objective
function value.
}
\description{
Optimize a sample configuration for spatial interpolation with a known linear model. A criterion is defined 
so that the sample configuration minimizes the mean or maximum kriging variance (\bold{MKV}).
}
\details{
Details about the mechanism used to generate a new sample configuration out of the current sample 
configuration by randomly perturbing the coordinates of a sample point are available in the help page of
\code{\link[spsann]{spJitter}}.
}
\note{
The distance between two points is computed as the Euclidean distance between them. This computation 
assumes that the optimization is operating in the two-dimensional Euclidean space, i.e. the coordinates of
the sample points and candidate locations should not be provided as latitude/longitude. \pkg{spsann} has no 
mechanism to check if the coordinates are projected: the user is responsible for making sure that this
requirement is attained.

This function is based on the method originally proposed by Heuvelink, Brus and de Gruijter (2006) and 
implemented in the R-package \pkg{intamapInteractive} by Edzer Pebesma and Jon Skoien.
}
\examples{
\dontrun{
data(meuse.grid, package = "sp")
candi <- meuse.grid[1:1000, 1:2]
covars <- as.data.frame(meuse.grid)[1:1000, ]
vgm <- gstat::vgm(psill = 10, model = "Exp", range = 500, nugget = 8)
schedule <- scheduleSPSANN(
  initial.temperature = 10, chains = 1, x.max = 1540, y.max = 2060, 
  x.min = 0,  y.min = 0, cellsize = 40)
set.seed(2001)
res <- optimMKV(
  points = 10, candi = candi, covars = covars, eqn = z ~ dist, 
  vgm = vgm, schedule = schedule)
objSPSANN(res) - objMKV(
  points = res, candi = candi, covars = covars,  eqn = z ~ dist, 
  vgm = vgm)
}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\references{
Brus, D. J.; Heuvelink, G. B. M. Optimization of sample patterns for universal kriging of environmental 
variables. \emph{Geoderma}. v. 138, p. 86-95, 2007.

Heuvelink, G. B. M.; Brus, D. J.; de Gruijter, J. J. Optimization of sample configurations for digital 
mapping of soil properties with universal kriging. In: Lagacherie, P.; McBratney, A. & Voltz, M. (Eds.)
\emph{Digital soil mapping - an introductory perspective}. Elsevier, v. 31, p. 137-151, 2006.
}
\concept{
simulated annealing

spatial interpolation
}
\keyword{iteration}
\keyword{optimize}
\keyword{spatial}

