% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{IrregularMoransI}
\alias{IrregularMoransI}
\title{Moran's I between two groups (irregular data shape)}
\usage{
IrregularMoransI(
  X,
  W,
  group1,
  group2,
  OLS = FALSE,
  normalize = TRUE,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH"
)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{group1}{The indices or names for the first group of observations.}

\item{group2}{The indices or names for the second group of observations.}

\item{OLS}{Whether to use \code{\link[spots]{OLSMoransI}}, default is \code{FALSE} and \code{\link[spots]{BivariateMoransI}} is used.}

\item{normalize}{Whether to normalize the weight matrix such that each row adds up to one. Default is \code{TRUE}.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}
}
\value{
A list containing the output from \code{\link[spots]{BivariateMoransI}} or \code{\link[spots]{OLSMoransI}}.
}
\description{
Calculate Moran's I between two groups with irregular data shape.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- IrregularMoransI(data.use[,3:4], W, 1:10, 21:30)
}

}
\concept{moransi}
