% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-hockey.R
\name{hockey_goal_crease_outline}
\alias{hockey_goal_crease_outline}
\title{The goal crease is the area where a goaltender plays their position. It is
comprised of two components: the outline of the crease, and the filling in
its boundary (see \code{\link[=hockey_goal_crease_fill]{hockey_goal_crease_fill()}}). The goal crease may have two
notches (one on each side of the line y = 0)}
\usage{
hockey_goal_crease_outline(
  feature_radius = 0,
  feature_thickness = 0,
  crease_style = "",
  crease_length = 0,
  crease_width = 0,
  notch_dist_x = 0,
  notch_width = 0
)
}
\arguments{
\item{feature_radius}{The radius of the goal crease}

\item{feature_thickness}{The thickness of the line marking the outline of the
goal crease}

\item{crease_style}{The style of the goal crease}

\item{crease_length}{The length of the goal crease}

\item{crease_width}{The width of the goal crease}

\item{notch_dist_x}{The distance from the back edge of the goal line to the
further edge of the crease notch}

\item{notch_width}{The width of the notch in the goal crease}
}
\value{
A data frame containing the bounding coordinates of the goal crease's
outline
}
\description{
The outline of the goal crease should have thickness given by
'minor_line_thickness', as this is a minor line on the ice surface, and the
outline is usually red in color
}
\keyword{internal}
