% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{summary.rating}
\alias{summary.rating}
\title{Summarizing rating objects}
\usage{
\method{summary}{rating}(object, ...)
}
\arguments{
\item{object}{of class rating}

\item{...}{optional arguments}
}
\value{
List with following elements \itemize{
\item \code{formula} modelled formula.
\item \code{method} type of algorithm used.
\item \code{Overall Accuracy} named vector containing players ratings.
\item \code{r} data.frame summarized players ratings and model winning probabilities. Probabilities are returned only in models with one variable (ratings) \itemize{
\item \code{name} of a player
\item \code{r} players ratings
\item \code{rd} players ratings deviation
\item \code{`Model probability`} mean predicted probability of winning the challange by the player.
\item \code{`True probability`} mean observed probability of winninh the challange by the player.
\item \code{`Accuracy`} Accuracy of prediction.
\item \code{`pairings`} number of pairwise occurences.
}
}
}
\description{
Summarizing rating objects
Summary for object of class `rating`
}
\examples{
model <- glicko_run(rank|id~rider, gpheats[1:100,]) 
summary(model)
}
