% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{as.png.spork}
\alias{as.png.spork}
\title{Convert Spork to PNG}
\usage{
\method{as.png}{spork}(
  x,
  filename = tempfile(),
  width = 3,
  height = 1,
  units = "in",
  res = 150,
  ...
)
}
\arguments{
\item{x}{spork; see \code{\link{as_spork}}}

\item{filename}{path for image file}

\item{width}{width}

\item{height}{height}

\item{units}{units}

\item{res}{resolution}

\item{...}{passed arguments}
}
\value{
invisible filepath
}
\description{
Converts spork to png.
}
\examples{
library(magrittr)
library(latexpdf)
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as.png -> file
file
}
\seealso{
Other preview: 
\code{\link{as.png.plotmath}()},
\code{\link{as_preview.latex}()},
\code{\link{as_preview.plotmath}()},
\code{\link{as_previews.spork}()},
\code{\link{as_previews}()},
\code{\link{as_preview}()},
\code{\link{ggplot.plotmath}()},
\code{\link{ggplot.spork}()}

Other spork: 
\code{\link{[.spork}()},
\code{\link{[[.spork}()},
\code{\link{as.list.spork}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spar.spork}()},
\code{\link{as_spork.character}()},
\code{\link{as_spork.factor}()},
\code{\link{as_spork.spork}()},
\code{\link{as_spork}()},
\code{\link{ggplot.spork}()}

Other png: 
\code{\link{as.png.plotmath}()}
}
\concept{png}
\concept{preview}
\concept{spork}
\keyword{internal}
