% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{spnet.map.plot.position}
\alias{spnet.map.plot.position}
\alias{spnet.map.plot.position,SpatialNetwork-method}
\alias{spnet.map.plot.position,SpatialPolygons-method}
\title{Plot a map labelled with the ID numbering}
\usage{
spnet.map.plot.position(x, label = "", ...)

\S4method{spnet.map.plot.position}{SpatialPolygons}(x, label = "", ...)

\S4method{spnet.map.plot.position}{SpatialNetwork}(x, label = "", ...)
}
\arguments{
\item{x}{an object for which a \code{spnet.map.plot.position} method is defined.}

\item{label}{a character of length 1 for prefixing seat numbering.}

\item{...}{other arguments to pass to the plot function. The main usage is setting the \code{cex} value.}
}
\description{
The \code{spnet.map.plot.position} function allows to plot maps defined as for example \code{SpatialNetwork} or \code{SpatialPolygons} objects, and render the ID numbering.
}
\section{Methods (by class)}{
\itemize{
\item \code{SpatialPolygons}: method for \code{SpatialPolygons} objects.

\item \code{SpatialNetwork}: method for \code{SpatialNetwork} objects.
}}
\examples{
# A room with tables in inversed 'U' form
col <- 5
row <- 6
m <- matrix(rep(-1, col*row), nrow = row)
m[1,2:4] <- 0
m[3,c(1,5)] <- 0
m[4,c(1,5)] <- 0
m[5,c(1,5)] <- 0
m[6,c(1,5)] <- 0
m
room1 <- room.create.grid(m, seat.width=2, seat.height=1)
spnet.map.plot.position(room1)
spnet.map.plot.position(room1, label = 'Seat ')
spnet.map.plot.position(room1, label = 'Seat ', cex = 0.8)
}

