% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcomp.R
\name{varcomp}
\alias{varcomp}
\alias{varcomp.splm}
\alias{varcomp.spautor}
\title{Variability component comparison}
\usage{
varcomp(object, ...)

\method{varcomp}{splm}(object, ...)

\method{varcomp}{spautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tibble that partitions the the total variability by the fixed effects
and each variance parameter. The proportion of variability explained by the
fixed effects is the pseudo R-squared obtained by \code{psuedoR2()}. The
remaining proportion is spread accordingly among each variance parameter:
\code{"de"}, \code{"ie"}, and if random effects are used, each named random effect.
If \code{spautor()} objects have unconnected sites, a list is returned with three elements:
\code{"connected"} for a variability comparison among the connected sites;
\code{"unconnected"} for a variability comparison among the unconnected
sites; and \code{"ratio"} for the ratio of the variance of the connected
sites relative to the variance of the unconnected sites.
}
\description{
Compare the proportion of total variability explained by the fixed effects
and each variance parameter.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
varcomp(spmod)
}
