% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.spmod}
\alias{plot.spmod}
\title{Plot fitted model diagnostics}
\usage{
\method{plot}{spmod}(x, which, ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{which}{An integer vector taking on values between 1 and 7, which indicates
the plots to return. Available plots are described in Details. If \code{which}
has length greater than one, additional plots are stepped through in order
using \code{<Return>}. The default for \code{\link[=splm]{splm()}} fitted model objects is
\code{which = c(1, 2, 7)}. The default for \code{\link[=spautor]{spautor()}} fitted model objects
is \code{which = c(1, 2)}.}

\item{...}{Other arguments passed to other methods.}
}
\value{
No return value. Function called for plotting side effects.
}
\description{
Plot fitted model diagnostics such as residuals vs fitted values,
quantile-quantile, scale-location, Cook's distance, residuals vs leverage,
Cook's distance vs leverage, and a fitted spatial covariance function.
}
\details{
For \code{\link[=splm]{splm()}} and \code{\link[=spautor]{spautor()}}, the values of \code{which} make the
corresponding plot:
\itemize{
\item{1:}{ Standardized residuals vs fitted values (of the response)}
\item{2:}{ Normal quantile-quantile plot of standardized residuals}
\item{3:}{ Scale-location plot of standardized residuals}
\item{4:}{ Cook's distance}
\item{5:}{ Standardized residuals vs leverage}
\item{6:}{ Cook's distance vs leverage}
}
For \code{\link[=splm]{splm()}}, there is an additional value of \code{which}:
\itemize{
\item{7:}{ Fitted spatial covariance function vs distance}
}
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
plot(spmod)
plot(spmod, which = c(1, 2, 4, 6))
}
