% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.acc.R
\name{pred.acc}
\alias{pred.acc}
\title{Predictive error and accuracy measures for predictive models based on cross-validation}
\usage{
pred.acc(obs, pred)
}
\arguments{
\item{obs}{a vector of observation values of validation samples.}

\item{pred}{a vector of prediction values of predictive models for validation samples.}
}
\value{
A list with the following components:
me, rme, mae, rmae, mse, rmse, rrmse and vecv.
}
\description{
This function is used to calculate the mean error (me), mean absolute error
(mae), mean squared error (mse), relative me (rme), relative mae (rmae),
root mse (rmse), relative rmse (rrmse), variance explained by predictive
models based on cross-validation (vecv). They are based on the differences
between the predicted values for and the observed values of validation
samples for cross-validation.
}
\examples{
set.seed(1234)
x <- sample(1:30, 30)
e <- rnorm(30, 1)
y <- x + e
pred.acc(x, y)

y <- 0.8 * x + e
pred.acc(x, y)

}
\references{
Li, J., 2016. Assessing spatial predictive models in the environmental sciences: accuracy
measures, data variation and variance explained. Environmental Modelling & Software 80 1-8.
}
\author{
Jin Li
}
