% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{apply_split_indexes_to_stratum}
\alias{apply_split_indexes_to_stratum}
\title{Split a stratum based on a list of indexes}
\usage{
apply_split_indexes_to_stratum(stratum, indexes_1, indexes_2)
}
\arguments{
\item{stratum}{(data frame, tibble, list, or vector) stratum to split}

\item{indexes_1}{(vector) indexes for first split, which can be generated via \code{\link{get_split_indexes_from_stratum}}}

\item{indexes_2}{(vector) indexes for second split, which can be generated via \code{\link{get_split_indexes_from_stratum}}}
}
\value{
(list) List with two elements that contain stratum split in two parts.
}
\description{
Splits \code{stratum} into two parts based on a list of indexes.  For more information
about splitting options, and an extensive list of examples, see
\code{\link{get_split_indexes_from_stratum}}.
}
\examples{
# Random split-half. One of the splits gets 4 elements and the other 5
stratum =  letters[1:9]
indexes = get_split_indexes_from_stratum(stratum)
apply_split_indexes_to_stratum(stratum, indexes[[1]], indexes[[2]])
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
