% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineCoxreg1.R
\name{splineCox.reg1}
\alias{splineCox.reg1}
\title{Fitting the five-parameter spline Cox model giving a specified shape}
\usage{
splineCox.reg1(
  t.event,
  event,
  Z,
  xi1 = min(t.event),
  xi3 = max(t.event),
  model = "constant",
  p0 = rep(0, 1 + ncol(as.matrix(Z)))
)
}
\arguments{
\item{t.event}{a vector for time-to-event}

\item{event}{a vector for event indicator (=1 event; =0 censoring)}

\item{Z}{a matrix for covariates; nrow(Z)=sample size, ncol(Z)=the number of covariates}

\item{xi1}{lower bound for the hazard function; the default is \code{min(t.event)}}

\item{xi3}{upper bound for the hazard function; the default is \code{max(t.event)}}

\item{model}{A character string specifying the shape of the baseline hazard function or a numeric vector of length 5 representing custom weights.
If a numeric vector is provided, it will be normalized to have an L1 norm of 1.
Available options include:
"increase", "constant", "decrease", "unimodal1", "unimodal2", "unimodal3", "bathtub1", "bathtub2", "bathtub3".
Default is "constant"}

\item{p0}{Initial values to maximize the likelihood (1 + p parameters; baseline hazard scale parameter and p regression coefficients)}
}
\value{
A list containing the following components:
\item{model}{A shape of the baseline hazard function or the normalized custom numeric vector used.}
\item{parameter}{A numeric vector of the parameters defining the baseline hazard shape.}
\item{beta}{A named vector with the estimates, standard errors, and 95\% confidence intervals for the regression coefficients}
\item{gamma}{A named vector with the estimate, standard error, and 95\% confidence interval for the baseline hazard parameter}
\item{loglik}{A named vector containing the log-likelihood (\code{LogLikelihood}),
Akaike Information Criterion (\code{AIC}), and Bayesian Information Criterion (\code{BIC})}
}
\description{
\code{splineCox.reg1} estimates the parameters of a five-parameter spline Cox model based on a specified shape for the baseline hazard function.
The function calculates the estimates for the model parameters (beta) and the baseline hazard scale parameter (gamma), using non-linear optimization.
If a numeric vector is provided for the \code{model} parameter, it will be normalized to have an L1 norm of 1.
}
\examples{
# Example data
library(joint.Cox)
data(dataOvarian)
t.event = dataOvarian$t.event
event = dataOvarian$event
Z = dataOvarian$CXCL12

reg1 <- splineCox.reg1(t.event, event, Z, model = "constant")
print(reg1)

}
