% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_protocol.R
\name{set_protocol_manual}
\alias{set_protocol_manual}
\alias{set_protocol_manual.default}
\alias{set_protocol_manual.data.frame}
\title{Manually setting a testing profile}
\usage{
set_protocol_manual(duration, load = NULL)

\method{set_protocol_manual}{default}(duration, load)

\method{set_protocol_manual}{data.frame}(duration, load = NULL)
}
\arguments{
\item{duration}{Either a numeric vector containing the duration (in seconds)
load each load step, or a \code{data.frame} containing columns for duration
and load.}

\item{load}{A numeric vector of the same length as \code{duration} containing
the corresponding load of each step.}
}
\value{
A \code{data.frame} with the duration and load of each protocol step.
}
\description{
\code{set_protocol_manual()} allows to set any user-defined load profile
for an exercise test.
}
\section{Methods (by class)}{
\itemize{
\item \code{set_protocol_manual(default)}: Default method when duration and load are
given separately

\item \code{set_protocol_manual(data.frame)}: Method for data frames with a duration and a
load column

}}
\examples{
set_protocol_manual(
  duration = c(300, 120, 300, 60, 300),
  load = c(3, 5, 3, 6, 3)
)

# using a data.frame as input
pt_data <- data.frame(
  duration = c(180, 150, 120, 90, 60, 30),
  load = c(200, 250, 300, 350, 400, 450)
)
set_protocol_manual(pt_data)
}
\seealso{
\link{set_protocol} for protocol setting with helper functions.

\link{get_protocol} For automated extracting of protocols from raw data.
}
