% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_text}
\alias{proto_text}
\title{Tour proto for data, text labels}
\usage{
proto_text(
  aes_args = list(),
  identity_args = list(nudge_x = 0.05),
  rownum_index = NULL
)
}
\arguments{
\item{aes_args}{A list of aesthetic arguments to passed to
\verb{geom_point(aes(X)}. Any mapping of the data to an aesthetic,
for example, \code{geom_point(aes(color = myCol, shape = myCol))} becomes
\code{aes_args = list(color = myCol, shape = myCol)}.}

\item{identity_args}{A list of static, identity arguments passed into
\code{geom_point()}, but outside of \code{aes()}, for instance
\code{geom_point(aes(...), size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.}

\item{rownum_index}{One or more integers, the row numbers of the to
subset to. Should be within 1:n, the rows of the original data. Defaults to
NULL, labeling all rows.}
}
\description{
Adds \code{geom_text()} of the projected data.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species
bas <- basis_pca(dat)
mv <- manip_var_of(bas)
gt_path <- save_history(dat, tourr::grand_tour(), max_bases = 5)

ggt <- ggtour(gt_path, dat, angle = .2) +
  proto_text(list(color = clas))
\dontrun{
animate_plotly(ggt)}

## Custom labels, subset of points
ggt2 <- ggtour(gt_path, dat) +
  proto_text(list(color = clas, size = as.integer(clas)),
             list(alpha = .7),
             rownum_index = 1:15)
\dontrun{
animate_plotly(ggt2)}
}
\seealso{
Other ggtour proto: 
\code{\link{filmstrip}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()}
}
\concept{ggtour proto}
