% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{profileRotation}
\alias{profileRotation}
\title{Test rotation invariance of index functions for selected 2-d data set.}
\usage{
profileRotation(d, indexList, indexLabels, n = 200)
}
\arguments{
\item{d}{data (2 column matrix containing distribution to be rotated)}

\item{indexList}{list of index functions to calculate for each entry}

\item{indexLabels}{labels used in the output}

\item{n}{number of steps in the rotation (default = 200)}
}
\value{
index values for each rotation step
}
\description{
Ideally a projection pursuit index should be roation invariant, we
test this explicitly by profiling the index while rotating a
distribution.
}
\examples{
\donttest{
d <- as.matrix(sinData(2, 1000))
indexList <- list(tourr::holes(), scagIndex("Skinny"), splineIndex())
indexLabels <- c("holes", "skinny", "splines2d")
pRot <- profileRotation(d, indexList, indexLabels)
plotRotation(pRot)
}
}
