% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upscale.R
\name{upscale}
\alias{upscale}
\title{Upscaling of smooth components}
\usage{
upscale(f, coord, wavelet = "haar", wtrafo = "dwt", pad = mean(f),
  color.maps = FALSE)
}
\arguments{
\item{f}{A vector.}

\item{coord}{A matrix of two columns with corresponding cartesian
coordinates. Currently only supports integer coordinates.}

\item{wavelet}{Name of wavelet family. \code{haar}, \code{d4}, and \code{la8}.
are possible. \code{haar} is the default.}

\item{wtrafo}{Type of wavelet transform. Either \code{dwt} or \code{modwt}.
\code{dwt} is the default.}

\item{pad}{A numeric value for padding the matrix
into a bigger square. Default is set to mean(f).}

\item{color.maps}{A logical value. If \code{TRUE}, produces colorful maps.
If \code{FALSE}, produces grayscale maps. Default is grayscale. NOW DEPRECATED,
color maps will not be produced in future versions.}
}
\value{
A set of plots showing the matrix image at each value for
\code{level}.
}
\description{
The analysis is based a wavelet multiresolution analysis
using only smooth wavelet components.
It is a 2D analysis taking the grid structure and provides scale-specific
results for data sampled on a contiguous geographical area. The
dataset is assumed to be regular gridded and the grid cells are
assumed to be square.
The scale-dependent results are graphically displayed.
}
\examples{
data(carlinadata)
coords <- carlinadata[ ,4:5]

# Upscaling of smooth components
upscale(carlinadata$land.use, coord = coords)

}
\author{
Gudrun Carl
}
