% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spmblp}
\alias{spmblp}
\title{Polynomial Baseline Correction of a Matrix of Mid-infrared Spectra}
\usage{
spmblp(spectra, degree = 2, tol = 0.001, rep = 100)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{degree}{numeric. Degree of polynomial. Defaults to 2.}

\item{tol}{numeric. Tolerance of difference between iterations. Defaults to 0.001.}

\item{rep}{numeric. Maximum number of iterations. Defaults to 100.}
}
\value{
An object of class spmblp, which is a list with the following components:
  \item{original}{Matrix of original mid-infrared spectra.}
  \item{baseline}{Matrix of polynomial baseline of mid-infrared spectra.}
  \item{corrected}{Matrix of polynomial baseline corrected mid-infrared spectra.}
}
\description{
This function allows a polynomial correction of defects of the baseline of a mid-infrared spectrum.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# List of polynomial baseline components
mblp <- spmblp(spectra, degree = 2, tol = 0.001, rep = 100)
# Original matrix
original <- mblp$original
# Baseline matrix
baseline <- mblp$baseline
# Corrected matrix
corrected <- mblp$corrected
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}
\references{
Lieber, C. A., and Mahadevan-Jansen, A. (2003). Automated method for subtraction of fluorescence from biological Raman spectra. Applied spectroscopy, 57(11), 1363-1367.
}

