% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_ezsim.R
\name{spfrontier.true.value}
\alias{ezsimspfrontier}
\alias{spfrontier.true.value}
\title{True value for simulation}
\usage{
spfrontier.true.value()

ezsimspfrontier(runs, params, inefficiency = "half-normal",
  logging = "info", control = list())
}
\arguments{
\item{runs}{a number of simulated samples}

\item{params}{a set with parameters to be used in simulation.}

\item{inefficiency}{sets the distribution for inefficiency error component. Possible values are 'half-normal' (for half-normal distribution) and 'truncated' (for truncated normal distribution). 
By default set to 'half-normal'. See references for explanations}

\item{logging}{an optional level of logging. Possible values are 'quiet','warn','info','debug'. 
By default set to quiet.}

\item{control}{an optional list of control parameters for simulation process. Currently the procedure supports:\cr
ignoreWy (TRUE/FALSE) - the spatial contiguity matrix for a dependent variable is not provided to  \code{\link{spfrontier}} estimator (but used in DGP) 
ignoreWv (TRUE/FALSE) - the spatial contiguity matrix for a symmetric error term is not provided to  \code{\link{spfrontier}} estimator (but used in DGP) 
ignoreWu (TRUE/FALSE) - the spatial contiguity matrix for a inefficiency error term is not provided to  \code{\link{spfrontier}} estimator (but used in DGP) 
parallel (TRUE/FALSE) - whether to use parallel computer
seed  - a state for random number generation in R. If NULL (default), the initial state is random. See \code{\link{set.seed}} for details.
auto_save  - saves intermediate results to files. See \code{\link{ezsim}} for details.}
}
\description{
\code{spfrontier.true.value} returns true parameter values for a simulation process

\code{ezsimspfrontier} tests estimators of a spatial stochastic frontier model with different parameters
}
\details{
The \code{spfrontier.true.value} function should notbe used directly, it is exported for supporting \code{\link{ezsim}}

The \code{ezsimspfrontier} function executes multiple calls of the \code{spfrontier} estimator on a simulated data set, 
generated on the base of provided parameters. The resulting estimates can be analysed for biasedness, efficiency, etc.
}
\examples{
params000 <- list(n=c(50, 100),beta0=5,
                 beta1=10,
                 beta2=1,
                 sigmaV=0.5, 
                 sigmaU=2.5)
ctrl <- list(seed=999, cores=1)
res000 <- ezsimspfrontier(2, params = params000,  
                 inefficiency = "half-normal",
                 logging = "info", 
                 control=ctrl)
summary(res000)
}
\seealso{
\code{\link{ezsim}}
}
\keyword{frontier,}
\keyword{simulation}
\keyword{spatial}
\keyword{stochastic}

