\name{skiTum}
\docType{data}
\alias{skiTum}
\title{Simulated data mimicking a skin cancer chemoprevention trial}
\usage{skiTum}
\description{ A data frame contains data on the recurrence of skin tumor.
  This simulated data is created for illustrative purpose and it mimic
  the Skin Cancer Chemoprevention Trial used in Chiou et al. (2017).
  This data set contains records of 100 simulated patients.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{\code{id}}{: patient id (repeated for each recurrence)}
    \item{\code{time}}{: observation time}
    \item{\code{age}}{: patient's age at enrollment; age = 1 if greater
      than 65, age = 0 otherwise}
    \item{\code{male}}{: gender; male = 1, female = 0}
    \item{\code{dfmo}}{: treatment (DFMO) group = 1; placebo = 0}
    \item{\code{priorTumor}}{: number of prior tumor from diagnosis to randomization}
    \item{\code{count}}{: number of new tumors since last observation time}
  }
}
\references{
  Chiou, S., Xu, G., Yan, J., and Huang, C.-Y. (2017). Semiparametric
  estimation of the accelerated means model with panel count data with
  informative examination times. \emph{unpublished manuscript}
}
\examples{
data(skiTum)
library(ggplot2)
skiTum$dfmo <- factor(skiTum$dfmo, levels = c(1, 0), labels = c("placebo", "DFMO"))
ggplot(skiTum, aes(time, id, height = 2, width = 25)) +
    geom_tile(aes(fill = count)) + theme_bw() +
    facet_grid(dfmo ~ ., scales = "free_y") + 
    scale_fill_gradient(low = "grey", high = "black") + labs(fill="Count") +
    scale_x_continuous(breaks = seq(0, 1800, 100)) + xlab("Time in days")
}
\keyword{survival}
